/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Comparison;
import org.neo4j.values.TernaryComparator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValueGroup;

public abstract class VirtualPathValue
extends VirtualValue {
    public abstract long startNodeId();

    public abstract long endNodeId();

    public abstract long[] nodeIds();

    public abstract long[] relationshipIds();

    public abstract ListValue relationshipsAsList();

    public abstract int size();

    public abstract ListValue asList();

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.PATH;
    }

    @Override
    public int unsafeCompareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        VirtualPathValue otherPath = (VirtualPathValue)other;
        long[] nodes = this.nodeIds();
        long[] relationships = this.relationshipIds();
        long[] otherNodes = otherPath.nodeIds();
        long[] otherRelationships = otherPath.relationshipIds();
        int x = Long.compare(nodes[0], otherNodes[0]);
        if (x == 0) {
            int length = Math.min(relationships.length, otherRelationships.length);
            for (int i = 0; x == 0 && i < length; ++i) {
                x = Long.compare(relationships[i], otherRelationships[i]);
            }
            if (x == 0) {
                x = Integer.compare(relationships.length, otherRelationships.length);
            }
        }
        return x;
    }

    @Override
    public Comparison unsafeTernaryCompareTo(VirtualValue other, TernaryComparator<AnyValue> comparator) {
        return Comparison.from(this.unsafeCompareTo(other, comparator));
    }

    @Override
    public boolean equals(VirtualValue other) {
        if (!(other instanceof VirtualPathValue)) {
            return false;
        }
        VirtualPathValue that = (VirtualPathValue)other;
        return this.size() == that.size() && Arrays.equals(this.nodeIds(), that.nodeIds()) && Arrays.equals(this.relationshipIds(), that.relationshipIds());
    }

    @Override
    protected int computeHashToMemoize() {
        long[] nodes = this.nodeIds();
        long[] relationships = this.relationshipIds();
        int result = Long.hashCode(nodes[0]);
        for (int i = 1; i < nodes.length; ++i) {
            result += 31 * (result + Long.hashCode(relationships[i - 1]));
            result += 31 * (result + Long.hashCode(nodes[i]));
        }
        return result;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapPath(this);
    }

    @Override
    public String getTypeName() {
        return "Path";
    }
}

