/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.hashing.HashFunction;
import org.neo4j.values.storable.ArrayValue;

public abstract class NonPrimitiveArray<T extends Comparable<? super T>>
extends ArrayValue {
    protected abstract T[] value();

    @Override
    public final boolean equals(boolean[] x) {
        return false;
    }

    @Override
    public final boolean equals(char[] x) {
        return false;
    }

    @Override
    public final boolean equals(String[] x) {
        return false;
    }

    @Override
    public final boolean equals(byte[] x) {
        return false;
    }

    @Override
    public final boolean equals(short[] x) {
        return false;
    }

    @Override
    public final boolean equals(int[] x) {
        return false;
    }

    @Override
    public final boolean equals(long[] x) {
        return false;
    }

    @Override
    public final boolean equals(float[] x) {
        return false;
    }

    @Override
    public final boolean equals(double[] x) {
        return false;
    }

    final int compareToNonPrimitiveArray(NonPrimitiveArray<T> other) {
        int compare = 0;
        int length = Math.min(this.intSize(), other.intSize());
        for (int index = 0; compare == 0 && index < length; ++index) {
            compare = this.value()[index].compareTo(other.value()[index]);
        }
        return compare == 0 ? Integer.compare(this.intSize(), other.intSize()) : compare;
    }

    @Override
    protected int computeHashToMemoize() {
        return Arrays.hashCode(this.value());
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        hash = hashFunction.update(hash, (long)this.intSize());
        for (Comparable obj : this.value()) {
            hash = hashFunction.update(hash, (long)obj.hashCode());
        }
        return hash;
    }

    @Override
    public final int intSize() {
        return this.value().length;
    }

    public final T[] asObjectCopy() {
        Comparable[] value = this.value();
        return Arrays.copyOf(value, value.length);
    }

    @Deprecated
    public final T[] asObject() {
        return this.value();
    }

    @Override
    public final String prettyPrint() {
        return Arrays.toString(this.value());
    }

    public final String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.value());
    }
}

