/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.pki;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.pki.PemFormats;

final class PemParser {
    private static final String BEGIN = "-----BEGIN ";
    private static final String END = "-----END ";
    private static final Base64.Decoder BASE_64 = Base64.getMimeDecoder();
    private static final Map<String, PemFormats.PemFormat> parsers = Map.of("PUBLIC KEY", new PemFormats.Pkcs8(), "PRIVATE KEY", new PemFormats.Pkcs8(), "ENCRYPTED PRIVATE KEY", new PemFormats.Pkcs8Encrypted(), "RSA PUBLIC KEY", new PemFormats.PemPKCS1Rsa(), "RSA PRIVATE KEY", new PemFormats.PemPKCS1Rsa(), "DSA PRIVATE KEY", new PemFormats.PemPKCS1Dsa(), "EC PRIVATE KEY", new PemFormats.PemPKCS1Ec());
    private String label;
    private byte[] der;
    private final Map<String, String> headers = new HashMap<String, String>();

    PemParser(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.US_ASCII));){
            this.parse(reader);
        }
    }

    PrivateKey getPrivateKey(String password) throws KeyException {
        PemFormats.PemFormat pemFormat = parsers.get(this.label);
        if (pemFormat != null) {
            return pemFormat.decodePrivate(this.der, this.headers, password);
        }
        throw new KeyException(String.format("Provided PEM does not contain a private key, found '%s'.", this.label));
    }

    PublicKey getPublicKey() throws KeyException {
        PemFormats.PemFormat pemFormat = parsers.get(this.label);
        if (pemFormat != null) {
            return pemFormat.decodePublicKey(this.der);
        }
        throw new KeyException(String.format("Provided PEM does not contain a public key, found '%s'.", this.label));
    }

    private void parse(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (line != null && !line.startsWith(BEGIN)) {
            line = reader.readLine();
        }
        if (line == null) {
            throw new IllegalStateException("File does not contain -----BEGIN  encapsulation boundary.");
        }
        this.label = PemParser.extractLabel(line);
        String endMarker = END + this.label;
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (line.contains(endMarker)) {
                this.der = BASE_64.decode(sb.toString());
                return;
            }
            if (line.contains(":")) {
                String[] kv = line.split(":");
                this.headers.put(kv[0].trim(), kv[1].trim());
                continue;
            }
            sb.append(line.trim());
        }
        throw new IllegalStateException("Missing footer: " + endMarker + ".");
    }

    private static String extractLabel(String line) {
        line = line.substring(BEGIN.length());
        int index = line.indexOf(45);
        if (!line.endsWith("-----") || line.length() - index != "-----".length()) {
            throw new IllegalStateException(String.format("Unable to find label, expecting '-----BEGIN (label)-----' but found '%s'.", line));
        }
        return line.substring(0, index);
    }
}

