/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.InternalLog;

public interface FileRepository {
    public static Path getMigratedFile(Path path) {
        return path.resolveSibling(String.valueOf(path.getFileName()) + ".migrated");
    }

    public static void assertNotMigrated(Path path, FileSystemAbstraction fileSystem, InternalLog log) {
        Path migratedFile = FileRepository.getMigratedFile(path);
        if (fileSystem.fileExists(migratedFile)) {
            String message = "The repository file '" + String.valueOf(path.toAbsolutePath()) + "' has been marked as migrated. If you are sure that you want use this repository you need to manually rename the file '" + String.valueOf(migratedFile.toAbsolutePath()) + "' to '" + String.valueOf(path.getFileName()) + "'";
            log.error(message);
            throw new IllegalStateException(message);
        }
    }
}

