/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class IndexNotFoundKernelException
extends KernelException {
    private final IndexDescriptor index;

    private IndexNotFoundKernelException(ErrorGqlStatusObject gqlStatusObject, String msg, IndexDescriptor index) {
        super(gqlStatusObject, (Status)Status.Schema.IndexNotFound, msg, new Object[0]);
        this.index = index;
    }

    public static IndexNotFoundKernelException indexIsStillPopulating(String indexPopulationJobDescription) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N63).build();
        return new IndexNotFoundKernelException(gql, "Index is still populating: " + indexPopulationJobDescription, null);
    }

    public static IndexNotFoundKernelException indexIsStillPopulating(IndexDescriptor descriptor) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N63).build();
        return new IndexNotFoundKernelException(gql, String.valueOf(descriptor) + " is still populating", descriptor);
    }

    public static IndexNotFoundKernelException indexDroppedWhileSampling() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N64).build();
        return new IndexNotFoundKernelException(gql, "Index dropped while sampling.", null);
    }

    public static IndexNotFoundKernelException indexNotFound(IndexDescriptor index) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N69).withParam(GqlParams.StringParam.idxDescrOrName, index.getName()).build();
        return new IndexNotFoundKernelException(gql, "Index does not exist: " + index.getName(), index);
    }

    public static IndexNotFoundKernelException indexNotFound() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N69).build();
        return new IndexNotFoundKernelException(gql, "No index was found", null);
    }

    public static IndexNotFoundKernelException indexDroppedInThisTransaction(IndexDescriptor index) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N12).withParam(GqlParams.StringParam.idx, index.getName()).build();
        return new IndexNotFoundKernelException(gql, "Index has been dropped in this transaction: " + index.getName(), index);
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        if (this.index == null) {
            return super.getUserMessage(tokenNameLookup);
        }
        return super.getUserMessage(tokenNameLookup) + this.index.userDescription(tokenNameLookup);
    }
}

