/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.transaction.database;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.fabric.bookmark.LocalGraphTransactionIdTracker;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.executor.Location;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.KernelTransactionFactory;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.router.impl.transaction.database.LocalDatabaseTransaction;
import org.neo4j.router.transaction.DatabaseTransaction;
import org.neo4j.router.transaction.DatabaseTransactionFactory;
import org.neo4j.router.transaction.TransactionInfo;

public class LocalDatabaseTransactionFactory
implements DatabaseTransactionFactory<Location.Local> {
    private final DatabaseContextProvider<?> databaseContextProvider;
    private final LocalGraphTransactionIdTracker transactionIdTracker;

    public LocalDatabaseTransactionFactory(DatabaseContextProvider<?> databaseContextProvider, LocalGraphTransactionIdTracker transactionIdTracker) {
        this.databaseContextProvider = databaseContextProvider;
        this.transactionIdTracker = transactionIdTracker;
    }

    @Override
    public DatabaseTransaction beginTransaction(Location.Local location, TransactionInfo transactionInfo, TransactionBookmarkManager bookmarkManager) {
        DatabaseContext databaseContext = (DatabaseContext)this.databaseContextProvider.getDatabaseContext(location.databaseReference().databaseId()).orElseThrow(LocalDatabaseTransactionFactory.databaseNotFound(location.getDatabaseName()));
        GraphDatabaseAPI databaseApi = databaseContext.databaseFacade();
        DependencyResolver resolver = databaseContext.dependencies();
        QueryExecutionEngine queryExecutionEngine = (QueryExecutionEngine)resolver.resolveDependency(QueryExecutionEngine.class);
        TransactionalContextFactory transactionalContextFactory = Neo4jTransactionalContextFactory.create((Supplier)resolver.provideDependency(GraphDatabaseQueryService.class), (KernelTransactionFactory)((KernelTransactionFactory)resolver.resolveDependency(KernelTransactionFactory.class)));
        bookmarkManager.getBookmarkForLocal(location).ifPresent(bookmark -> this.transactionIdTracker.awaitGraphUpToDate(location, bookmark.transactionId()));
        InternalTransaction internalTransaction = this.beginInternalTransaction(databaseApi, transactionInfo);
        return new LocalDatabaseTransaction(location, transactionInfo, internalTransaction, transactionalContextFactory, queryExecutionEngine, bookmarkManager, this.transactionIdTracker);
    }

    private InternalTransaction beginInternalTransaction(GraphDatabaseAPI databaseApi, TransactionInfo transactionInfo) {
        InternalTransaction internalTransaction = databaseApi.beginTransaction(transactionInfo.type(), transactionInfo.loginContext(), transactionInfo.clientInfo(), transactionInfo.txTimeout().toMillis(), TimeUnit.MILLISECONDS);
        internalTransaction.setMetaData(transactionInfo.txMetadata());
        return internalTransaction;
    }

    private static Supplier<DatabaseNotFoundException> databaseNotFound(String databaseNameRaw) {
        return () -> new DatabaseNotFoundException("Database " + databaseNameRaw + " not found");
    }
}

