/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.bolt;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.dbapi.BoltQueryExecution;
import org.neo4j.bolt.dbapi.BoltTransaction;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.common.message.request.connection.RoutingContext;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.fabric.bolt.QueryRouterBookmark;
import org.neo4j.fabric.bookmark.BookmarkFormat;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionConfiguration;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.router.QueryRouter;
import org.neo4j.router.query.DatabaseReferenceResolver;
import org.neo4j.router.query.Query;
import org.neo4j.router.transaction.RouterTransaction;
import org.neo4j.router.transaction.RouterTransactionContext;
import org.neo4j.router.transaction.TransactionInfo;
import org.neo4j.values.virtual.MapValue;

public class QueryRouterBoltSpi {

    private record Execution(QueryExecution queryExecution) implements BoltQueryExecution
    {
        public void close() {
            this.queryExecution.cancel();
        }

        public void terminate() {
            this.queryExecution.cancel();
        }
    }

    private static class Transaction
    implements BoltTransaction {
        private final QueryRouter queryRouter;
        private final RouterTransactionContext routerTransactionContext;
        private final RouterTransaction routerTransaction;

        Transaction(QueryRouter queryRouter, RouterTransactionContext routerTransactionContext) {
            this.queryRouter = queryRouter;
            this.routerTransactionContext = routerTransactionContext;
            this.routerTransaction = routerTransactionContext.routerTransaction();
        }

        public BoltQueryExecution executeQuery(String query, MapValue parameters, boolean prePopulate, QuerySubscriber subscriber) {
            return new Execution(this.queryRouter.executeQuery(this.routerTransactionContext, Query.of(query, parameters), subscriber));
        }

        public void commit() {
            this.routerTransaction.commit();
        }

        public void rollback() {
            this.routerTransaction.rollback();
        }

        public void close() {
        }

        public void markForTermination(Status reason) {
            this.routerTransaction.markForTermination(reason);
        }

        public void markForTermination() {
            this.routerTransaction.markForTermination((Status)Status.Transaction.Terminated);
        }

        public Optional<Status> getReasonIfTerminated() {
            return this.routerTransaction.getReasonIfTerminated();
        }

        public String getBookmark() {
            return BookmarkFormat.serialize((QueryRouterBookmark)this.routerTransactionContext.txBookmarkManager().constructFinalBookmark());
        }
    }

    private record Database(String sessionDatabaseName, QueryRouter queryRouter, DatabaseReferenceResolver databaseReferenceResolver, BoltGraphDatabaseServiceSPI compositeStack) implements BoltGraphDatabaseServiceSPI
    {
        public BoltTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo, List<String> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata, RoutingContext routingContext, QueryExecutionConfiguration queryExecutionConfiguration) {
            NormalizedDatabaseName normalizedSessionDatabaseName = new NormalizedDatabaseName(this.sessionDatabaseName);
            DatabaseReference sessionDatabaseReference = this.databaseReferenceResolver.resolve(new NormalizedDatabaseName(this.sessionDatabaseName));
            if (sessionDatabaseReference.isComposite()) {
                return this.compositeStack.beginTransaction(type, loginContext, clientInfo, bookmarks, txTimeout, accessMode, txMetadata, routingContext, queryExecutionConfiguration);
            }
            TransactionInfo transactionInfo = new TransactionInfo(normalizedSessionDatabaseName, type, loginContext, clientInfo, bookmarks, txTimeout, accessMode, txMetadata, routingContext, queryExecutionConfiguration);
            return new Transaction(this.queryRouter, this.queryRouter.beginTransaction(transactionInfo));
        }

        public DatabaseReference getDatabaseReference() {
            return this.databaseReferenceResolver.resolve(this.sessionDatabaseName);
        }
    }

    public static class DatabaseManagementService
    implements BoltGraphDatabaseManagementServiceSPI {
        private final QueryRouter queryRouter;
        private final DatabaseReferenceResolver databaseReferenceResolver;
        private final BoltGraphDatabaseManagementServiceSPI compositeStack;

        public DatabaseManagementService(QueryRouter queryRouter, DatabaseReferenceResolver databaseReferenceResolver, BoltGraphDatabaseManagementServiceSPI compositeStack) {
            this.queryRouter = queryRouter;
            this.databaseReferenceResolver = databaseReferenceResolver;
            this.compositeStack = compositeStack;
        }

        public BoltGraphDatabaseServiceSPI database(String databaseName, MemoryTracker memoryTracker) throws UnavailableException, DatabaseNotFoundException {
            return new Database(databaseName, this.queryRouter, this.databaseReferenceResolver, this.compositeStack.database(databaseName, memoryTracker));
        }
    }
}

