/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.util.List;
import java.util.function.Function;
import org.neo4j.cypher.internal.evaluator.EvaluationException;
import org.neo4j.cypher.internal.evaluator.ExpressionEvaluator;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;

public class ByteArrayConverter
implements Function<String, DefaultParameterValue> {
    private final ExpressionEvaluator evaluator;

    ByteArrayConverter(ExpressionEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public DefaultParameterValue apply(String s) {
        try {
            List evaluate = (List)this.evaluator.evaluate(s, List.class);
            if (evaluate == null) {
                return DefaultParameterValue.ntByteArray(null);
            }
            byte[] bytes = new byte[evaluate.size()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = ByteArrayConverter.safeGetByte(evaluate.get(i));
            }
            return DefaultParameterValue.ntByteArray((byte[])bytes);
        }
        catch (EvaluationException e) {
            throw new IllegalArgumentException(String.format("%s is not a valid list expression", s), e);
        }
    }

    private static byte safeGetByte(Object value) {
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        throw new IllegalArgumentException(String.format("Expected list to contain numbers but got %s", value));
    }
}

