/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.neo4j.ogm.config.Credentials;

public class UsernamePasswordCredentials
implements Credentials<String> {
    private final String credentials;
    private final String username;
    private final String password;

    public UsernamePasswordCredentials(String username, String password) {
        if (username == null || password == null) {
            throw new IllegalArgumentException("username or password cannot be null");
        }
        this.credentials = Base64.getEncoder().encodeToString(String.format("%s:%s", username, password).getBytes(StandardCharsets.UTF_8));
        this.username = username;
        this.password = password;
    }

    @Override
    public String credentials() {
        return this.credentials;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

