/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.neo4j.ogm.config.ConfigurationSource;

public class FileConfigurationSource
implements ConfigurationSource {
    private final Properties properties = new Properties();

    public FileConfigurationSource(String propertiesFilePath) {
        try (FileInputStream is = new FileInputStream(this.createFile(propertiesFilePath));){
            this.properties.load(is);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Could not load properties file: " + propertiesFilePath, e);
        }
    }

    private File createFile(String propertiesFilePath) throws URISyntaxException {
        if (propertiesFilePath.toLowerCase().startsWith("file:")) {
            return new File(new URI(propertiesFilePath));
        }
        return new File(propertiesFilePath);
    }

    @Override
    public Properties properties() {
        return this.properties;
    }
}

