/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.writer;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.schema.WritableDatabaseSchemaIndex;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;

public class PartitionedIndexWriter
implements LuceneIndexWriter {
    private WritableDatabaseSchemaIndex index;
    private final Integer MAXIMUM_PARTITION_SIZE = Integer.getInteger("luceneSchemaIndex.maxPartitionSize", 0x73333333);

    public PartitionedIndexWriter(WritableDatabaseSchemaIndex index) throws IOException {
        this.index = index;
    }

    @Override
    public void addDocument(Document doc) throws IOException {
        this.getIndexWriter().addDocument((Iterable)doc);
    }

    @Override
    public void addDocuments(Iterable<Document> documents) throws IOException {
        this.getIndexWriter().addDocuments(documents);
    }

    @Override
    public void updateDocument(Term term, Document doc) throws IOException {
        List<AbstractIndexPartition> partitions = this.index.getPartitions();
        if (this.index.hasSinglePartition(partitions)) {
            this.index.getFirstPartition(partitions).getIndexWriter().updateDocument(term, (Iterable)doc);
        } else {
            this.deleteDocuments(term);
            this.addDocument(doc);
        }
    }

    @Override
    public void deleteDocuments(Query query) throws IOException {
        List<AbstractIndexPartition> partitions = this.index.getPartitions();
        for (AbstractIndexPartition partition : partitions) {
            partition.getIndexWriter().deleteDocuments(new Query[]{query});
        }
    }

    @Override
    public void deleteDocuments(Term term) throws IOException {
        List<AbstractIndexPartition> partitions = this.index.getPartitions();
        for (AbstractIndexPartition partition : partitions) {
            partition.getIndexWriter().deleteDocuments(new Term[]{term});
        }
    }

    private synchronized IndexWriter getIndexWriter() throws IOException {
        List<AbstractIndexPartition> indexPartitions = this.index.getPartitions();
        Optional<AbstractIndexPartition> writablePartition = indexPartitions.stream().filter(this::writablePartition).findFirst();
        if (writablePartition.isPresent()) {
            return writablePartition.get().getIndexWriter();
        }
        AbstractIndexPartition indexPartition = this.index.addNewPartition();
        return indexPartition.getIndexWriter();
    }

    private boolean writablePartition(AbstractIndexPartition partition) {
        return partition.getIndexWriter().numDocs() < this.MAXIMUM_PARTITION_SIZE;
    }
}

