/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.event;

import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.event.ComponentNamespace;
import org.neo4j.logging.event.DebugEventPublisher;
import org.neo4j.logging.event.Parameters;
import org.neo4j.logging.event.Type;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.PrefixedLogProvider;
import org.neo4j.util.VisibleForTesting;

class LoggingDebugEventPublisher
implements DebugEventPublisher {
    private final Log debugLog;

    LoggingDebugEventPublisher(InternalLogProvider logProvider, ComponentNamespace component) {
        PrefixedLogProvider prefixLogProvider = new PrefixedLogProvider(logProvider, "Event");
        this.debugLog = prefixLogProvider.getLog(component.getName());
    }

    LoggingDebugEventPublisher(LogService logService, ComponentNamespace component) {
        PrefixedLogProvider prefixLogger = new PrefixedLogProvider(logService.getInternalLogProvider(), "Event");
        this.debugLog = prefixLogger.getLog(component.getName());
    }

    @VisibleForTesting
    LoggingDebugEventPublisher(Log log) {
        this.debugLog = log;
    }

    @Override
    public void publish(Type type, String message, Parameters parameters) {
        switch (type) {
            case Begin: 
            case Finish: {
                this.debugLog.info("%s - %s %s", new Object[]{type, message, parameters});
                break;
            }
            case Info: {
                this.debugLog.info("%s %s", message, parameters);
                break;
            }
            case Warn: {
                this.debugLog.warn("%s %s", message, parameters);
                break;
            }
            case Error: {
                this.debugLog.error("%s %s", message, parameters);
            }
        }
    }

    @Override
    public void publish(Type type, String message) {
        this.publish(type, message, Parameters.EMPTY);
    }
}

