/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.lock;

import java.util.Collection;
import java.util.Collections;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceType;

public interface ResourceLocker {
    public static final ResourceLocker IGNORE = new IgnoreResourceLocker();

    public boolean tryExclusiveLock(ResourceType var1, long var2);

    public boolean trySharedLock(ResourceType var1, long var2);

    public void acquireExclusive(LockTracer var1, ResourceType var2, long ... var3);

    public void releaseExclusive(ResourceType var1, long ... var2);

    public void acquireShared(LockTracer var1, ResourceType var2, long ... var3);

    public void releaseShared(ResourceType var1, long ... var2);

    public Collection<ActiveLock> activeLocks();

    public boolean holdsLock(long var1, ResourceType var3, LockType var4);

    public static class IgnoreResourceLocker
    implements ResourceLocker {
        @Override
        public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
            return false;
        }

        @Override
        public boolean trySharedLock(ResourceType resourceType, long resourceId) {
            return false;
        }

        @Override
        public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
        }

        @Override
        public void releaseExclusive(ResourceType resourceType, long ... resourceIds) {
        }

        @Override
        public void acquireShared(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
        }

        @Override
        public void releaseShared(ResourceType resourceType, long ... resourceIds) {
        }

        @Override
        public Collection<ActiveLock> activeLocks() {
            return Collections.emptyList();
        }

        @Override
        public boolean holdsLock(long id, ResourceType resource, LockType lockType) {
            return false;
        }
    }
}

