/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.hopscotch.IntArrayBasedKeyTable;

public class LongKeyLongValueTable
extends IntArrayBasedKeyTable<long[]> {
    public static final long NULL = -1L;

    public LongKeyLongValueTable(int capacity) {
        super(capacity, 5, 32, new long[]{-1L});
    }

    @Override
    public long key(int index) {
        return this.getLong(this.address(index));
    }

    @Override
    protected void internalPut(int actualIndex, long key, long[] value) {
        this.putLong(actualIndex, key);
        this.putLong(actualIndex + 2, value[0]);
    }

    @Override
    public long[] putValue(int index, long[] value) {
        int actualValueIndex = this.address(index) + 2;
        long previous = this.getLong(actualValueIndex);
        this.putLong(actualValueIndex, value[0]);
        return this.pack(previous);
    }

    @Override
    public long[] value(int index) {
        return this.pack(this.getLong(this.address(index) + 2));
    }

    protected LongKeyLongValueTable newInstance(int newCapacity) {
        return new LongKeyLongValueTable(newCapacity);
    }

    private long[] pack(long value) {
        ((long[])this.singleValue)[0] = value;
        return (long[])this.singleValue;
    }
}

