/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout.recordstorage;

import java.nio.file.Path;
import java.util.stream.Stream;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.CommonDatabaseStores;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.PlainDatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseFile;

public class RecordDatabaseLayout
extends PlainDatabaseLayout {
    private RecordDatabaseLayout(Neo4jLayout neo4jLayout, String databaseName) {
        super(neo4jLayout, databaseName);
    }

    public static RecordDatabaseLayout of(Neo4jLayout neo4jLayout, String databaseName) {
        return new RecordDatabaseLayout(neo4jLayout, databaseName);
    }

    public static RecordDatabaseLayout ofFlat(Path databaseDirectory) {
        Path canonical = FileUtils.getCanonicalFile((Path)databaseDirectory);
        Path home = canonical.getParent();
        String dbName = canonical.getFileName().toString();
        return RecordDatabaseLayout.of(Neo4jLayout.ofFlat(home), dbName);
    }

    public static RecordDatabaseLayout cast(DatabaseLayout layout) {
        if (layout instanceof RecordDatabaseLayout) {
            return (RecordDatabaseLayout)layout;
        }
        throw new IllegalArgumentException(layout.toString() + " does not describe a record storage database.");
    }

    public static RecordDatabaseLayout convert(DatabaseLayout layout) {
        return layout instanceof RecordDatabaseLayout ? (RecordDatabaseLayout)layout : RecordDatabaseLayout.of(layout.getNeo4jLayout(), layout.getDatabaseName());
    }

    public static RecordDatabaseLayout of(Config config) {
        return RecordDatabaseLayout.of(Neo4jLayout.of((Configuration)config), (String)config.get(GraphDatabaseSettings.initial_default_database));
    }

    @Override
    public Path pathForExistsMarker() {
        return this.file(RecordDatabaseFile.EXISTS_MARKER.getName());
    }

    @Override
    public Path pathForStore(CommonDatabaseStores store) {
        return switch (store) {
            default -> throw new IncompatibleClassChangeError();
            case CommonDatabaseStores.NODE -> this.nodeStore();
            case CommonDatabaseStores.COUNTS -> this.countStore();
            case CommonDatabaseStores.LABEL_TOKENS -> this.labelTokenStore();
            case CommonDatabaseStores.RELATIONSHIP_TYPE_TOKENS -> this.relationshipTypeTokenStore();
            case CommonDatabaseStores.PROPERTY_KEY_TOKENS -> this.propertyKeyTokenStore();
            case CommonDatabaseStores.SCHEMAS -> this.schemaStore();
            case CommonDatabaseStores.INDEX_STATISTICS -> this.indexStatisticsStore();
            case CommonDatabaseStores.METADATA -> this.metadataStore();
        };
    }

    public Path countStore() {
        return this.file(RecordDatabaseFile.COUNTS_STORE.getName());
    }

    public Path relationshipGroupDegreesStore() {
        return this.file(RecordDatabaseFile.RELATIONSHIP_GROUP_DEGREES_STORE.getName());
    }

    public Path propertyStringStore() {
        return this.file(RecordDatabaseFile.PROPERTY_STRING_STORE.getName());
    }

    public Path relationshipStore() {
        return this.file(RecordDatabaseFile.RELATIONSHIP_STORE.getName());
    }

    public Path propertyStore() {
        return this.file(RecordDatabaseFile.PROPERTY_STORE.getName());
    }

    public Path nodeStore() {
        return this.file(RecordDatabaseFile.NODE_STORE.getName());
    }

    public Path nodeLabelStore() {
        return this.file(RecordDatabaseFile.NODE_LABEL_STORE.getName());
    }

    public Path propertyArrayStore() {
        return this.file(RecordDatabaseFile.PROPERTY_ARRAY_STORE.getName());
    }

    public Path propertyKeyTokenStore() {
        return this.file(RecordDatabaseFile.PROPERTY_KEY_TOKEN_STORE.getName());
    }

    public Path propertyKeyTokenNamesStore() {
        return this.file(RecordDatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE.getName());
    }

    public Path relationshipTypeTokenStore() {
        return this.file(RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE.getName());
    }

    public Path relationshipTypeTokenNamesStore() {
        return this.file(RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE.getName());
    }

    public Path labelTokenStore() {
        return this.file(RecordDatabaseFile.LABEL_TOKEN_STORE.getName());
    }

    public Path schemaStore() {
        return this.file(RecordDatabaseFile.SCHEMA_STORE.getName());
    }

    public Path relationshipGroupStore() {
        return this.file(RecordDatabaseFile.RELATIONSHIP_GROUP_STORE.getName());
    }

    public Path labelTokenNamesStore() {
        return this.file(RecordDatabaseFile.LABEL_TOKEN_NAMES_STORE.getName());
    }

    @Override
    public Path indexStatisticsStore() {
        return this.file(RecordDatabaseFile.INDEX_STATISTICS_STORE.getName());
    }

    @Override
    public Path metadataStore() {
        return this.file(RecordDatabaseFile.METADATA_STORE.getName());
    }

    public Path idNodeStore() {
        return this.idFile(RecordDatabaseFile.NODE_STORE.getName());
    }

    public Path idNodeLabelStore() {
        return this.idFile(RecordDatabaseFile.NODE_LABEL_STORE.getName());
    }

    public Path idPropertyStore() {
        return this.idFile(RecordDatabaseFile.PROPERTY_STORE.getName());
    }

    public Path idPropertyKeyTokenStore() {
        return this.idFile(RecordDatabaseFile.PROPERTY_KEY_TOKEN_STORE.getName());
    }

    public Path idPropertyKeyTokenNamesStore() {
        return this.idFile(RecordDatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE.getName());
    }

    public Path idPropertyStringStore() {
        return this.idFile(RecordDatabaseFile.PROPERTY_STRING_STORE.getName());
    }

    public Path idPropertyArrayStore() {
        return this.idFile(RecordDatabaseFile.PROPERTY_ARRAY_STORE.getName());
    }

    public Path idRelationshipStore() {
        return this.idFile(RecordDatabaseFile.RELATIONSHIP_STORE.getName());
    }

    public Path idRelationshipGroupStore() {
        return this.idFile(RecordDatabaseFile.RELATIONSHIP_GROUP_STORE.getName());
    }

    public Path idRelationshipTypeTokenStore() {
        return this.idFile(RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE.getName());
    }

    public Path idRelationshipTypeTokenNamesStore() {
        return this.idFile(RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE.getName());
    }

    public Path idLabelTokenStore() {
        return this.idFile(RecordDatabaseFile.LABEL_TOKEN_STORE.getName());
    }

    public Path idLabelTokenNamesStore() {
        return this.idFile(RecordDatabaseFile.LABEL_TOKEN_NAMES_STORE.getName());
    }

    public Path idSchemaStore() {
        return this.idFile(RecordDatabaseFile.SCHEMA_STORE.getName());
    }

    protected Stream<RecordDatabaseFile> databaseFiles() {
        return RecordDatabaseFile.STORE_FILES.stream();
    }

    @Override
    protected boolean isRecoverableStore(DatabaseFile file) {
        assert (file instanceof RecordDatabaseFile);
        return RecordDatabaseFile.RECOVERABLE_STORE_FILES.contains(file);
    }
}

