/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.event;

import java.util.Collection;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.kernel.internal.event.InternalTransactionEventListener;
import org.neo4j.kernel.internal.event.TransactionListenersState;
import org.neo4j.kernel.internal.event.TxStateTransactionDataSnapshot;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;

public class TransactionEventListeners {
    private final DatabaseTransactionEventListeners databaseEventListeners;
    private final KernelTransaction ktx;
    private final StorageReader storageReader;
    private final GraphDatabaseFacade databaseFacade;
    public TransactionListenersState listenersState;
    private Collection<TransactionEventListener<?>> listenersSnapshot;

    public TransactionEventListeners(DatabaseTransactionEventListeners databaseEventListeners, KernelTransaction ktx, StorageReader storageReader) {
        this.databaseEventListeners = databaseEventListeners;
        this.databaseFacade = databaseEventListeners.getDatabaseFacade();
        this.ktx = ktx;
        this.storageReader = storageReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCommit(TxState txState, boolean isCommitCall) throws TransactionFailureException {
        if (this.listenersSnapshot == null) {
            this.listenersSnapshot = this.databaseEventListeners.getCurrentRegisteredTransactionEventListeners();
        }
        TransactionListenersState newState = this.beforeCommit((ReadableTransactionState)txState, this.ktx, this.storageReader, this.listenersSnapshot, isCommitCall);
        try {
            if (newState != null && newState.isFailed()) {
                Throwable cause = newState.failure();
                if (cause instanceof TransientFailureException) {
                    TransientFailureException tfe = (TransientFailureException)cause;
                    throw tfe;
                }
                if (cause instanceof Status.HasStatus) {
                    Status.HasStatus se = (Status.HasStatus)cause;
                    throw new TransactionFailureException(se.status(), cause, cause.getMessage(), new Object[0]);
                }
                throw new TransactionFailureException((Status)Status.Transaction.TransactionHookFailed, cause, cause.getMessage(), new Object[0]);
            }
        }
        finally {
            this.listenersState = newState;
        }
    }

    public void reset() {
        this.listenersSnapshot = null;
        this.listenersState = null;
    }

    public void afterCommit() {
        this.afterCommit(this.listenersState);
    }

    public void afterRollback() {
        this.afterRollback(this.listenersState);
    }

    public Throwable failure() {
        if (this.listenersState == null) {
            return null;
        }
        return this.listenersState.failure();
    }

    TransactionListenersState beforeCommit(ReadableTransactionState state, KernelTransaction transaction, StorageReader storageReader, Collection<TransactionEventListener<?>> eventListeners, boolean isCommitCall) {
        if (!TransactionEventListeners.canInvokeBeforeCommitListeners(eventListeners, state)) {
            return null;
        }
        TxStateTransactionDataSnapshot txData = new TxStateTransactionDataSnapshot(state, storageReader, transaction, isCommitCall);
        TransactionListenersState listenersStates = new TransactionListenersState(txData);
        boolean hasDataChanges = state.hasDataChanges();
        boolean isSystem = this.databaseFacade.databaseId().isSystemDatabase();
        for (TransactionEventListener<?> listener : eventListeners) {
            boolean internal = listener instanceof InternalTransactionEventListener;
            if (!hasDataChanges && !internal && !isSystem) continue;
            Object listenerState = null;
            try {
                listenerState = !internal ? listener.beforeCommit((TransactionData)txData, (Transaction)transaction.internalTransaction(), (GraphDatabaseService)this.databaseFacade) : ((InternalTransactionEventListener)listener).beforeCommit(txData, transaction, this.databaseFacade);
            }
            catch (Throwable t) {
                listenersStates.failed(t);
            }
            listenersStates.addListenerState(listener, listenerState);
        }
        return listenersStates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void afterCommit(TransactionListenersState listeners) {
        if (listeners == null) {
            return;
        }
        TransactionData txData = listeners.getTxData();
        Throwable error = null;
        try {
            for (TransactionListenersState.ListenerState<?> listenerState : listeners.getStates()) {
                TransactionEventListener<?> listener = listenerState.listener();
                try {
                    listener.afterCommit(txData, listenerState.state(), (GraphDatabaseService)this.databaseFacade);
                }
                catch (Throwable t) {
                    error = Exceptions.chain(error, (Throwable)t);
                }
            }
            if (error != null) {
                Exceptions.throwIfUnchecked(error);
                throw new RuntimeException(error);
            }
        }
        finally {
            this.closeTxDataSnapshot(txData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void afterRollback(TransactionListenersState listenersState) {
        if (listenersState == null) {
            return;
        }
        TransactionData txData = listenersState.getTxData();
        Throwable error = null;
        try {
            for (TransactionListenersState.ListenerState<?> listenerState : listenersState.getStates()) {
                TransactionEventListener<?> listener = listenerState.listener();
                try {
                    listener.afterRollback(txData, listenerState.state(), (GraphDatabaseService)this.databaseFacade);
                }
                catch (Throwable t) {
                    error = Exceptions.chain(error, (Throwable)t);
                }
            }
            if (error != null) {
                Exceptions.throwIfUnchecked(error);
                throw new RuntimeException(error);
            }
        }
        finally {
            this.closeTxDataSnapshot(txData);
        }
    }

    private void closeTxDataSnapshot(TransactionData txData) {
        assert (txData instanceof TxStateTransactionDataSnapshot);
        ((TxStateTransactionDataSnapshot)txData).close();
    }

    private static boolean canInvokeBeforeCommitListeners(Collection<TransactionEventListener<?>> listeners, ReadableTransactionState state) {
        return !listeners.isEmpty() && TransactionEventListeners.canInvokeListenersWithTransactionState(state);
    }

    private static boolean canInvokeListenersWithTransactionState(ReadableTransactionState state) {
        return state != null && state.hasChanges();
    }
}

