/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.Flushable;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.UnclosableChannel;
import org.neo4j.kernel.impl.transaction.log.FlushableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.log.LogForceEvent;
import org.neo4j.kernel.impl.transaction.log.LogForceEvents;
import org.neo4j.kernel.impl.transaction.log.LogForceWaitEvent;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadUtils;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFileChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.files.LogFileVersionTracker;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogHeaderVisitor;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionVisitor;
import org.neo4j.kernel.impl.transaction.log.files.RangeLogVersionVisitor;
import org.neo4j.kernel.impl.transaction.log.files.ThreadLink;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogChannelAllocator;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFileInformation;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.kernel.impl.transaction.log.rotation.FileLogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLog;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Panic;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

public class TransactionLogFile
extends LifecycleAdapter
implements LogFile {
    private final AtomicReference<ThreadLink> threadLinkHead = new AtomicReference<ThreadLink>(ThreadLink.END);
    private final Lock forceLock = new ReentrantLock();
    private final AtomicLong rotateAtSize;
    private final TransactionLogFilesHelper fileHelper;
    private final TransactionLogFilesContext context;
    private final LogVersionBridge readerLogVersionBridge;
    private final MemoryTracker memoryTracker;
    private final TransactionLogFileInformation logFileInformation;
    private final TransactionLogChannelAllocator channelAllocator;
    private final DatabaseHealth databaseHealth;
    private final LogFiles logFiles;
    private final LogRotation logRotation;
    private final LogHeaderCache logHeaderCache;
    private final FileSystemAbstraction fileSystem;
    private final ConcurrentMap<Long, List<StoreChannel>> externalFileReaders = new ConcurrentHashMap<Long, List<StoreChannel>>();
    private final LogFileVersionTracker versionTracker;
    private final InternalLog logger;
    private final LogRotationMonitor rotationMonitor;
    private volatile PhysicalLogVersionedStoreChannel channel;
    private PhysicalFlushableLogPositionAwareChannel writer;
    private LogVersionRepository logVersionRepository;
    private TransactionLogWriter transactionLogWriter;

    TransactionLogFile(LogFiles logFiles, TransactionLogFilesContext context) {
        this.logFiles = logFiles;
        this.context = context;
        this.rotateAtSize = context.getRotationThreshold();
        this.fileSystem = context.getFileSystem();
        this.databaseHealth = context.getDatabaseHealth();
        this.versionTracker = context.getLogFileVersionTracker();
        this.fileHelper = TransactionLogFilesHelper.forTransactions((FileSystemAbstraction)this.fileSystem, (Path)logFiles.logFilesDirectory());
        this.logHeaderCache = new LogHeaderCache(1000);
        this.logFileInformation = new TransactionLogFileInformation(logFiles, this.logHeaderCache, context);
        this.channelAllocator = new TransactionLogChannelAllocator(context, this.fileHelper, this.logHeaderCache, new LogFileChannelNativeAccessor(this.fileSystem, context));
        this.readerLogVersionBridge = ReaderLogVersionBridge.forFile(this);
        this.rotationMonitor = (LogRotationMonitor)context.getMonitors().newMonitor(LogRotationMonitor.class, new String[0]);
        this.logRotation = FileLogRotation.transactionLogRotation(this, context.getClock(), (Panic)this.databaseHealth, this.rotationMonitor);
        this.memoryTracker = context.getMemoryTracker();
        this.logger = context.getLogProvider().getLog(TransactionLogFile.class);
    }

    public void init() throws IOException {
        this.logVersionRepository = this.context.getLogVersionRepositoryProvider().logVersionRepository(this.logFiles);
    }

    public void start() throws IOException {
        long currentLogVersion = this.logVersionRepository.getCurrentLogVersion();
        this.channel = this.createLogChannelForVersion(currentLogVersion, this.context::appendIndex, this.context.getKernelVersionProvider(), this.context.getLastCommittedChecksumProvider().getLastCommittedChecksum(this.logFiles));
        LogHeader logHeader = this.extractHeader(currentLogVersion);
        KernelVersion currentKernelVersion = this.context.getKernelVersionProvider().kernelVersion();
        KernelVersion logHeaderKernelVersion = logHeader.getKernelVersion();
        if (currentKernelVersion.isAtLeast(KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_INTRODUCED) && logHeaderKernelVersion != currentKernelVersion) {
            assert (logHeaderKernelVersion == null || currentKernelVersion.isGreaterThan(logHeaderKernelVersion));
            this.rotateOnStart(logHeader);
            currentLogVersion = this.logVersionRepository.getCurrentLogVersion();
        }
        ((LogRotationMonitor)this.context.getMonitors().newMonitor(LogRotationMonitor.class, new String[0])).started(this.channel.getPath(), currentLogVersion);
        this.seekChannelPosition(currentLogVersion);
        PhysicalFlushableLogPositionAwareChannel.VersionedPhysicalFlushableLogChannelProvider channelProvider = new PhysicalFlushableLogPositionAwareChannel.VersionedPhysicalFlushableLogChannelProvider(this.logRotation, this.context.getDatabaseTracers().getDatabaseTracer(), (ScopedBuffer)new NativeScopedBuffer(this.context.getBufferSizeBytes(), ByteOrder.LITTLE_ENDIAN, this.memoryTracker));
        this.writer = new PhysicalFlushableLogPositionAwareChannel((LogVersionedStoreChannel)this.channel, this.channelAllocator.readLogHeaderForVersion(currentLogVersion), channelProvider);
        if (!this.context.isReadOnly()) {
            this.transactionLogWriter = new TransactionLogWriter((FlushableLogPositionAwareChannel)this.writer, this.context.getKernelVersionProvider(), this.context.getBinarySupportedKernelVersions(), this.logRotation);
        }
    }

    private void rotateOnStart(LogHeader logHeader) throws IOException {
        long startTimeMillis = this.context.getClock().millis();
        this.rotationMonitor.startRotation(logHeader.getLogVersion());
        long newLogVersion = this.logVersionRepository.incrementAndGetVersion();
        this.seekChannelPosition(logHeader.getLogVersion());
        long endSize = this.channel.position();
        this.channel.truncate(endSize);
        PhysicalLogVersionedStoreChannel newLog = this.createLogChannelForVersion(newLogVersion, this.context::appendIndex, this.context.getKernelVersionProvider(), this.context.getLastCommittedChecksumProvider().getLastCommittedChecksum(this.logFiles));
        this.channel.close();
        this.channel = newLog;
        long rotationElapsedTime = this.context.getClock().millis() - startTimeMillis;
        this.rotationMonitor.finishLogRotation(this.channel.getPath(), logHeader.getLogVersion(), this.context.appendIndex(), rotationElapsedTime, 0L);
    }

    public void shutdown() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new PhysicalFlushableLogPositionAwareChannel[]{this.writer});
    }

    @Override
    public PhysicalLogVersionedStoreChannel openForVersion(long version) throws IOException {
        return this.openForVersion(version, false);
    }

    @Override
    public PhysicalLogVersionedStoreChannel openForVersion(long version, boolean raw) throws IOException {
        return this.channelAllocator.openLogChannel(version, raw);
    }

    @Override
    public PhysicalLogVersionedStoreChannel createLogChannelForVersion(long version, LongSupplier lastAppendIndexSupplier, KernelVersionProvider kernelVersionProvider, int previousLogFileChecksum) throws IOException {
        return this.channelAllocator.createLogChannel(version, lastAppendIndexSupplier.getAsLong(), previousLogFileChecksum, kernelVersionProvider);
    }

    @Override
    public PhysicalLogVersionedStoreChannel createLogChannelForExistingVersion(long version) throws IOException {
        return this.channelAllocator.createLogChannelExistingVersion(version);
    }

    @Override
    public boolean rotationNeeded() throws IOException {
        return this.writer.getCurrentLogPosition().getByteOffset() >= this.rotateAtSize.get();
    }

    @Override
    public void truncate() throws IOException {
        this.truncate(this.writer.getCurrentLogPosition());
    }

    @Override
    public synchronized void truncate(LogPosition targetPosition) throws IOException {
        long targetVersion;
        long currentVersion = this.writer.getCurrentLogPosition().getLogVersion();
        if (currentVersion < (targetVersion = targetPosition.getLogVersion())) {
            throw new IllegalArgumentException("Log position requested for restore points to the log file that is higher than existing available highest log file. Requested restore position: " + String.valueOf(targetPosition) + ", current log file version: " + currentVersion + ".");
        }
        LogPosition lastClosed = this.context.getLastClosedTransactionPositionProvider().lastClosedPosition(this.logFiles);
        if (TransactionLogFile.isCoveredByCommittedTransaction(targetPosition, targetVersion, lastClosed)) {
            throw new IllegalArgumentException("Log position requested to be used for restore belongs to the log file that was already appended by transaction and cannot be restored. Last closed position: " + String.valueOf(lastClosed) + ", requested restore: " + String.valueOf(targetPosition));
        }
        this.writer.prepareForFlush().flush();
        if (currentVersion != targetVersion) {
            PhysicalLogVersionedStoreChannel oldChannel = this.channel;
            this.channel = this.createLogChannelForVersion(targetVersion, this.context::appendIndex, this.context.getKernelVersionProvider(), -559063315);
            this.writer.setChannel((LogVersionedStoreChannel)this.channel, this.channelAllocator.readLogHeaderForVersion(targetVersion));
            oldChannel.close();
            for (long i = currentVersion; i > targetVersion; --i) {
                this.delete(i);
            }
        }
        this.channel.truncate(targetPosition.getByteOffset());
        this.channel.position(this.channel.size());
    }

    @Override
    public synchronized LogPosition append(ByteBuffer byteBuffer, OptionalLong appendIndex, Optional<Byte> kernelVersionByte, int checksum, long offset) throws IOException {
        Preconditions.checkArgument((boolean)byteBuffer.isDirect(), (String)"It is required for byte buffer to be direct.");
        TransactionLogWriter transactionLogWriter = this.getTransactionLogWriter();
        try (LogAppendEvent logAppendEvent = this.context.getDatabaseTracers().getDatabaseTracer().logAppend();){
            long totalAppended = transactionLogWriter.append(byteBuffer, logAppendEvent, appendIndex, kernelVersionByte, checksum, offset);
            logAppendEvent.appendedBytes(totalAppended);
            LogPosition logPosition = transactionLogWriter.beforeAppendPosition();
            return logPosition;
        }
    }

    @Override
    public synchronized Path rotate() throws IOException {
        return this.rotate(this.context::appendIndex);
    }

    @Override
    public synchronized Path rotate(KernelVersion kernelVersion, long lastAppendIndex, int checksum) throws IOException {
        this.channel = this.rotate((LogVersionedStoreChannel)this.channel, () -> lastAppendIndex, () -> kernelVersion, () -> checksum);
        this.writer.setChannel((LogVersionedStoreChannel)this.channel, this.channelAllocator.readLogHeaderForVersion(this.channel.getLogVersion()));
        return this.channel.getPath();
    }

    @Override
    public synchronized Path rotate(KernelVersion kernelVersion) throws IOException {
        throw new UnsupportedOperationException("Transaction log does not support this type of rotation");
    }

    @Override
    public long rotationSize() {
        return this.rotateAtSize.get();
    }

    public synchronized Path rotate(long appendIndex) throws IOException {
        return this.rotate(() -> appendIndex);
    }

    @Override
    public LogRotation getLogRotation() {
        return this.logRotation;
    }

    @Override
    public TransactionLogWriter getTransactionLogWriter() {
        if (this.context.isReadOnly()) {
            throw new UnsupportedOperationException("Trying to create writer in read only mode.");
        }
        return this.transactionLogWriter;
    }

    @Override
    public void flush() throws IOException {
        this.writer.prepareForFlush().flush();
    }

    @Override
    public ReadableLogChannel getReader(LogPosition position) throws IOException {
        return this.getReader(position, this.readerLogVersionBridge);
    }

    @Override
    public ReadableLogChannel getRawReader(LogPosition position) throws IOException {
        return this.getReader(position, this.readerLogVersionBridge, true);
    }

    @Override
    public ReadableLogChannel getReader(LogPosition position, LogVersionBridge logVersionBridge) throws IOException {
        return this.getReader(position, logVersionBridge, false);
    }

    private ReadableLogChannel getReader(LogPosition position, LogVersionBridge logVersionBridge, boolean raw) throws IOException {
        PhysicalLogVersionedStoreChannel logChannel = this.openForVersion(position.getLogVersion(), raw);
        logChannel.position(position.getByteOffset());
        LogHeader logHeader = this.extractHeader(logChannel.getLogVersion());
        return ReadAheadUtils.newChannel((LogVersionedStoreChannel)logChannel, logVersionBridge, logHeader, this.memoryTracker, raw);
    }

    @Override
    public void accept(LogFile.LogFileVisitor visitor, LogPosition startingFromPosition) throws IOException {
        try (ReadableLogChannel reader = this.getReader(startingFromPosition);){
            visitor.visit((ReadableLogPositionAwareChannel)reader);
        }
    }

    @Override
    public TransactionLogFileInformation getLogFileInformation() {
        return this.logFileInformation;
    }

    @Override
    public long getLogVersion(Path file) {
        return TransactionLogFilesHelper.getLogVersion((Path)file);
    }

    @Override
    public Path getLogFileForVersion(long version) {
        return this.fileHelper.getLogFileForVersion(version);
    }

    @Override
    public Path getHighestLogFile() {
        return this.getLogFileForVersion(this.getHighestLogVersion());
    }

    @Override
    public boolean versionExists(long version) {
        return this.fileSystem.fileExists(this.getLogFileForVersion(version));
    }

    @Override
    public LogHeader extractHeader(long version) throws IOException {
        return this.extractHeader(version, true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasAnyEntries(long version) {
        try {
            Path logFile = this.getLogFileForVersion(version);
            LogHeader logHeader = this.extractHeader(version, false);
            if (logHeader == null) {
                return false;
            }
            int headerSize = Math.toIntExact(logHeader.getStartPosition().getByteOffset());
            if (this.fileSystem.getFileSize(logFile) <= (long)headerSize) {
                return false;
            }
            try (StoreChannel channel = this.fileSystem.read(logFile);){
                boolean bl;
                try (HeapScopedBuffer scopedBuffer = new HeapScopedBuffer(headerSize + 1, ByteOrder.LITTLE_ENDIAN, this.context.getMemoryTracker());){
                    ByteBuffer buffer = scopedBuffer.getBuffer();
                    channel.readAll(buffer);
                    buffer.flip();
                    bl = buffer.get(headerSize) != 0;
                }
                return bl;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public long getCurrentLogVersion() {
        if (this.logVersionRepository != null) {
            return this.logVersionRepository.getCurrentLogVersion();
        }
        return this.getHighestLogVersion();
    }

    @Override
    public long getHighestLogVersion() {
        RangeLogVersionVisitor visitor = new RangeLogVersionVisitor();
        this.accept((LogVersionVisitor)visitor);
        return visitor.getHighestVersion();
    }

    @Override
    public long getLowestLogVersion() {
        RangeLogVersionVisitor visitor = new RangeLogVersionVisitor();
        this.accept((LogVersionVisitor)visitor);
        return visitor.getLowestVersion();
    }

    @Override
    public void accept(LogVersionVisitor visitor) {
        try {
            for (Path file : this.fileHelper.getMatchedFiles()) {
                visitor.visit(file, this.getLogVersion(file));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void accept(LogHeaderVisitor visitor) throws IOException {
        long logVersion = this.getHighestLogVersion();
        long highAppendIndex = this.context.getLastAppendIndexLogFilesProvider().getLastAppendIndex(this.logFiles);
        while (this.versionExists(logVersion)) {
            LogHeader logHeader = this.extractHeader(logVersion, false);
            if (logHeader != null) {
                long lowAppendIndex = logHeader.getLastAppendIndex() + 1L;
                LogPosition position = logHeader.getStartPosition();
                if (!visitor.visit(logHeader, position, lowAppendIndex, highAppendIndex)) break;
                highAppendIndex = logHeader.getLastAppendIndex();
            }
            --logVersion;
        }
    }

    @Override
    public Path[] getMatchedFiles() throws IOException {
        return this.fileHelper.getMatchedFiles();
    }

    @Override
    public void combine(Path additionalLogFilesDirectory) throws IOException {
        long highestLogVersion = this.getHighestLogVersion();
        TransactionLogFilesHelper logHelper = TransactionLogFilesHelper.forTransactions((FileSystemAbstraction)this.fileSystem, (Path)additionalLogFilesDirectory);
        for (Path matchedFile : logHelper.getMatchedFiles()) {
            long newFileVersion = ++highestLogVersion;
            Path newFileName = this.fileHelper.getLogFileForVersion(newFileVersion);
            this.fileSystem.renameFile(matchedFile, newFileName, new CopyOption[0]);
            try (StoreChannel channel = this.fileSystem.write(newFileName);){
                LogHeader logHeader = LogHeaderReader.readLogHeader(this.fileSystem, newFileName, this.memoryTracker);
                LogHeader writeHeader = new LogHeader(logHeader, newFileVersion);
                LogFormat.writeLogHeader((StoreChannel)channel, (LogHeader)writeHeader, (MemoryTracker)this.memoryTracker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forceAfterAppend(LogForceEvents logForceEvents) throws IOException {
        ThreadLink threadLink = new ThreadLink(Thread.currentThread());
        threadLink.next = this.threadLinkHead.getAndSet(threadLink);
        boolean attemptedForce = false;
        try (LogForceWaitEvent ignored = logForceEvents.beginLogForceWait();){
            do {
                if (this.forceLock.tryLock()) {
                    attemptedForce = true;
                    try {
                        this.forceLog(logForceEvents);
                    }
                    finally {
                        this.forceLock.unlock();
                        ThreadLink nextWaiter = this.threadLinkHead.get();
                        nextWaiter.unpark();
                    }
                } else {
                    this.waitForLogForce();
                }
            } while (!threadLink.done);
            if (!attemptedForce) {
                this.databaseHealth.assertNoPanic(IOException.class);
            }
        }
        return attemptedForce;
    }

    @Override
    public void locklessForce(LogForceEvents logForceEvents) throws IOException {
        try (LogForceEvent ignored = logForceEvents.beginLogForce();){
            this.flush();
        }
        catch (Throwable panic) {
            this.databaseHealth.panic(panic);
            throw panic;
        }
    }

    @Override
    public void delete(Long version) throws IOException {
        this.fileSystem.deleteFile(this.getLogFileForVersion(version));
        try {
            this.versionTracker.logDeleted(version);
        }
        catch (Throwable throwable) {
            this.logger.error("Error occurred whilst calling logDeleted in the LogFileVersionTracker", throwable);
        }
    }

    @Override
    public void registerExternalReaders(LongObjectMap<StoreChannel> internalChannels) {
        internalChannels.forEachKeyValue((LongObjectProcedure & Serializable)(version, channel) -> this.externalFileReaders.computeIfAbsent(version, any -> new CopyOnWriteArrayList()).add(channel));
    }

    @Override
    public void unregisterExternalReader(long version, StoreChannel channel) {
        this.externalFileReaders.computeIfPresent(version, (aLong, storeChannels) -> {
            storeChannels.remove(channel);
            if (storeChannels.isEmpty()) {
                return null;
            }
            return storeChannels;
        });
    }

    @Override
    public void terminateExternalReaders(long maxDeletedVersion) {
        this.externalFileReaders.entrySet().removeIf(entry -> {
            if ((Long)entry.getKey() <= maxDeletedVersion) {
                IOUtils.closeAllSilently((Collection)((Collection)entry.getValue()));
                return true;
            }
            return false;
        });
    }

    @VisibleForTesting
    public ConcurrentMap<Long, List<StoreChannel>> getExternalFileReaders() {
        return this.externalFileReaders;
    }

    private synchronized Path rotate(LongSupplier appendIndexSupplier) throws IOException {
        this.channel = this.rotate((LogVersionedStoreChannel)this.channel, appendIndexSupplier, this.context.getKernelVersionProvider(), () -> this.writer.currentChecksum().orElse(-559063315));
        this.writer.setChannel((LogVersionedStoreChannel)this.channel, this.channelAllocator.readLogHeaderForVersion(this.channel.getLogVersion()));
        return this.channel.getPath();
    }

    private PhysicalLogVersionedStoreChannel rotate(LogVersionedStoreChannel currentLog, LongSupplier lastAppendIndexSupplier, KernelVersionProvider kernelVersionProvider, IntSupplier checksumProvider) throws IOException {
        long newLogVersion = this.logVersionRepository.incrementAndGetVersion();
        this.writer.prepareForFlush().flush();
        long logVersion = currentLog.getLogVersion();
        long endSize = currentLog.position();
        currentLog.truncate(endSize);
        PhysicalLogVersionedStoreChannel newLog = this.createLogChannelForVersion(newLogVersion, lastAppendIndexSupplier, kernelVersionProvider, checksumProvider.getAsInt());
        currentLog.close();
        try {
            this.versionTracker.logCompleted(new LogPosition(logVersion, endSize));
        }
        catch (Throwable throwable) {
            this.logger.error("Error occurred whilst calling logCompleted in the LogFileVersionTracker", throwable);
        }
        return newLog;
    }

    private static boolean isCoveredByCommittedTransaction(LogPosition targetPosition, long targetVersion, LogPosition lastClosed) {
        return lastClosed.getLogVersion() > targetVersion || lastClosed.getLogVersion() == targetVersion && lastClosed.getByteOffset() > targetPosition.getByteOffset();
    }

    private void seekChannelPosition(long currentLogVersion) throws IOException {
        LogPosition position;
        this.jumpToTheLastClosedTxPosition(currentLogVersion);
        try {
            position = this.scanToEndOfLastLogEntry();
        }
        catch (Exception e) {
            this.jumpToLogStart(currentLogVersion);
            try {
                position = this.scanToEndOfLastLogEntry();
            }
            catch (Exception exception) {
                exception.addSuppressed(e);
                throw exception;
            }
        }
        this.channel.position(position.getByteOffset());
    }

    private LogPosition scanToEndOfLastLogEntry() throws IOException {
        LogHeader logHeader = this.extractHeader(this.channel.getLogVersion());
        try (ReadableLogChannel readAheadLogChannel = ReadAheadUtils.newChannel(new UnclosableChannel((LogVersionedStoreChannel)this.channel), logHeader, this.memoryTracker);){
            LogEntry entry;
            VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(this.context.getCommandReaderFactory(), this.context.getBinarySupportedKernelVersions());
            while ((entry = logEntryReader.readLogEntry((ReadableLogPositionAwareChannel)readAheadLogChannel)) != null) {
            }
            LogPosition logPosition = logEntryReader.lastPosition();
            return logPosition;
        }
    }

    private void jumpToTheLastClosedTxPosition(long currentLogVersion) throws IOException {
        LogPosition logPosition = this.context.getLastClosedTransactionPositionProvider().lastClosedPosition(this.logFiles);
        long lastTxOffset = logPosition.getByteOffset();
        long lastTxLogVersion = logPosition.getLogVersion();
        long startPosition = this.extractHeader(currentLogVersion).getStartPosition().getByteOffset();
        if (lastTxOffset < startPosition || this.channel.size() < lastTxOffset) {
            return;
        }
        if (lastTxLogVersion == currentLogVersion) {
            this.channel.position(lastTxOffset);
        }
    }

    private void jumpToLogStart(long currentLogVersion) throws IOException {
        this.channel.position(this.extractHeader(currentLogVersion).getStartPosition().getByteOffset());
    }

    private LogHeader extractHeader(long version, boolean strict) throws IOException {
        LogHeader logHeader = this.logHeaderCache.getLogHeader(version);
        if (logHeader == null) {
            logHeader = LogHeaderReader.readLogHeader(this.fileSystem, this.getLogFileForVersion(version), strict, this.context.getMemoryTracker());
            if (logHeader == null) {
                return null;
            }
            this.logHeaderCache.putHeader(version, logHeader);
        }
        return logHeader;
    }

    private void forceLog(LogForceEvents logForceEvents) throws IOException {
        ThreadLink links = this.threadLinkHead.getAndSet(ThreadLink.END);
        try (LogForceEvent ignored = logForceEvents.beginLogForce();){
            this.force();
        }
        catch (Throwable panic) {
            this.databaseHealth.panic(panic);
            throw panic;
        }
        finally {
            TransactionLogFile.unparkAll(links);
        }
    }

    private static void unparkAll(ThreadLink links) {
        ThreadLink tmp;
        do {
            links.done = true;
            links.unpark();
            while ((tmp = links.next) == null) {
            }
        } while ((links = tmp) != ThreadLink.END);
    }

    private void waitForLogForce() {
        long parkTime = TimeUnit.MILLISECONDS.toNanos(100L);
        LockSupport.parkNanos(this, parkTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void force() throws IOException {
        Flushable flushable;
        TransactionLogFile transactionLogFile = this;
        synchronized (transactionLogFile) {
            this.databaseHealth.assertNoPanic(IOException.class);
            flushable = this.writer.prepareForFlush();
        }
        try {
            flushable.flush();
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }
}

