/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.AbstractCheckPointThreshold;

class CountCommittedLogChunksThreshold
extends AbstractCheckPointThreshold {
    private final int notificationThreshold;
    private volatile long nextAppendIndexTarget;

    CountCommittedLogChunksThreshold(int notificationThreshold) {
        super("every " + notificationThreshold + " log chunks threshold");
        this.notificationThreshold = notificationThreshold;
    }

    @Override
    public void initialize(long appendIndex, LogPosition logPosition) {
        this.nextAppendIndexTarget = appendIndex + (long)this.notificationThreshold;
    }

    @Override
    protected boolean thresholdReached(long lastAppendIndex, LogPosition logPosition) {
        return lastAppendIndex >= this.nextAppendIndexTarget;
    }

    @Override
    public void checkPointHappened(long appendIndex, LogPosition logPosition) {
        this.nextAppendIndexTarget = appendIndex + (long)this.notificationThreshold;
    }

    @Override
    public long checkFrequencyMillis() {
        return DEFAULT_CHECKING_FREQUENCY_MILLIS;
    }
}

