/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StoreVersionIdentifier;

public record MigrationStatus(MigrationState state, StoreVersionIdentifier versionToMigrateFrom, StoreVersionIdentifier versionToMigrateTo) {
    public MigrationStatus() {
        this(null, null, null);
    }

    public boolean expectedMigration(StoreVersionIdentifier versionToMigrateTo) {
        return versionToMigrateTo != null && versionToMigrateTo.equals((Object)this.versionToMigrateTo);
    }

    public boolean migrationInProgress() {
        return this.state != null;
    }

    public static MigrationStatus readMigrationStatus(FileSystemAbstraction fs, Path stateFile, MemoryTracker memoryTracker) throws IOException {
        return MigrationStatus.readFromFile(fs, stateFile, memoryTracker);
    }

    private static MigrationStatus readFromFile(FileSystemAbstraction fs, Path path, MemoryTracker memoryTracker) throws IOException {
        List lines = FileSystemUtils.readLines((FileSystemAbstraction)fs, (Path)path, (MemoryTracker)memoryTracker);
        if (lines == null || lines.isEmpty()) {
            return new MigrationStatus();
        }
        String state = ((String)lines.get(0)).trim();
        StoreVersionIdentifier versionToMigrateFrom = MigrationStatus.parseStoreVersionIdentifier(((String)lines.get(1)).trim());
        StoreVersionIdentifier versionToMigrateTo = MigrationStatus.parseStoreVersionIdentifier(((String)lines.get(2)).trim());
        return new MigrationStatus(MigrationState.valueOf(state), versionToMigrateFrom, versionToMigrateTo);
    }

    private static String serializeStoreVersionIdentifier(StoreVersionIdentifier storeVersionIdentifier) {
        return String.format("%s|%s|%s|%s", storeVersionIdentifier.getStorageEngineName(), storeVersionIdentifier.getFormatName(), storeVersionIdentifier.getMajorVersion(), storeVersionIdentifier.getMinorVersion());
    }

    private static StoreVersionIdentifier parseStoreVersionIdentifier(String string) {
        String[] parts = string.split("\\|");
        if (parts.length != 4) {
            throw new IllegalStateException("Failed to parse store version identifier: " + string);
        }
        try {
            return new StoreVersionIdentifier(parts[0], parts[1], Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Failed to parse store version identifier: " + string);
        }
    }

    public static enum MigrationState {
        migrating,
        moving;


        public boolean isNeededFor(MigrationState current) {
            return current == null || this.ordinal() >= current.ordinal();
        }

        public void setMigrationStatus(FileSystemAbstraction fs, Path stateFile, StoreVersionIdentifier versionToMigrateFrom, StoreVersionIdentifier versionToMigrateTo, MemoryTracker memoryTracker) throws IOException {
            if (fs.fileExists(stateFile)) {
                try {
                    fs.truncate(stateFile, 0L);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            String status = this.name() + "\n" + MigrationStatus.serializeStoreVersionIdentifier(versionToMigrateFrom) + "\n" + MigrationStatus.serializeStoreVersionIdentifier(versionToMigrateTo);
            FileSystemUtils.writeString((FileSystemAbstraction)fs, (Path)stateFile, (String)status, (MemoryTracker)memoryTracker);
        }
    }
}

