/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.UniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.CollectingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.DeferredConflictCheckingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.FailureHeaderWriter;
import org.neo4j.kernel.impl.index.schema.FullScanNonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.kernel.impl.index.schema.NativeIndex;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.ThrowingConflictDetector;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;

public abstract class NativeIndexPopulator<KEY extends NativeIndexKey<KEY>>
extends NativeIndex<KEY>
implements IndexPopulator {
    public static final byte BYTE_FAILED = 0;
    static final byte BYTE_ONLINE = 1;
    static final byte BYTE_POPULATING = 2;
    protected final IndexUpdateIgnoreStrategy ignoreStrategy;
    private final KEY treeKey;
    private final UniqueIndexSampler uniqueSampler;
    private ConflictDetectingValueMerger<KEY, Value[]> mainConflictDetector;
    private ConflictDetectingValueMerger<KEY, Value[]> updatesConflictDetector;
    private byte[] failureBytes;
    private boolean dropped;
    private boolean closed;

    NativeIndexPopulator(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexLayout<KEY> layout, IndexDescriptor descriptor, ImmutableSet<OpenOption> openOptions) {
        super(databaseIndexContext, layout, indexFiles, descriptor, openOptions, false);
        this.treeKey = (NativeIndexKey)((Object)layout.newKey());
        this.uniqueSampler = descriptor.isUnique() ? new UniqueIndexSampler() : null;
        this.ignoreStrategy = this.indexUpdateIgnoreStrategy();
    }

    abstract NativeIndexReader<KEY> newReader();

    protected IndexUpdateIgnoreStrategy indexUpdateIgnoreStrategy() {
        return IndexUpdateIgnoreStrategy.NO_IGNORE;
    }

    public synchronized void create() throws IOException {
        this.assertNotDropped();
        this.assertNotClosed();
        this.indexFiles.clear();
        this.instantiateTree(RecoveryCleanupWorkCollector.immediate());
        this.mainConflictDetector = new ThrowingConflictDetector(!this.descriptor.isUnique(), this.descriptor.schema());
        this.updatesConflictDetector = new ThrowingConflictDetector(true, this.descriptor.schema());
    }

    public synchronized void drop() {
        try {
            if (this.tree != null) {
                this.tree.setDeleteOnClose(true);
            }
            this.closeTree();
            this.indexFiles.clear();
        }
        finally {
            this.dropped = true;
            this.closed = true;
        }
    }

    public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) throws IndexEntryConflictException {
        this.processUpdates(updates, this.mainConflictDetector, cursorContext);
    }

    public IndexUpdater newPopulatingUpdater(CursorContext cursorContext) {
        Object updater = new CollectingIndexUpdater(updates -> this.processUpdates(updates, this.updatesConflictDetector, cursorContext));
        if (this.descriptor.isUnique()) {
            updater = new DeferredConflictCheckingIndexUpdater((IndexUpdater)updater, this::newReader, this.descriptor, cursorContext);
        }
        return updater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean populationCompletedSuccessfully, CursorContext cursorContext) {
        block17: {
            if (populationCompletedSuccessfully && this.failureBytes != null) {
                throw new IllegalStateException("Can't mark index as online after it has been marked as failure");
            }
            try {
                this.assertNotDropped();
                if (populationCompletedSuccessfully) {
                    this.assertPopulatorOpen();
                    try (FileFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush();){
                        this.flushTreeAndMarkAs((byte)1, flushEvent, cursorContext);
                        break block17;
                    }
                }
                if (this.failureBytes == null) break block17;
                this.ensureTreeInstantiated();
                try (FileFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush();){
                    this.markTreeAsFailed(flushEvent, cursorContext);
                }
            }
            finally {
                this.closeTree();
                this.closed = true;
            }
        }
    }

    public void markAsFailed(String failure) {
        this.failureBytes = failure.getBytes(StandardCharsets.UTF_8);
    }

    public void includeSample(IndexEntryUpdate<?> update) {
        if (this.descriptor.isUnique()) {
            this.updateUniqueSample(update);
        }
    }

    public IndexSample sample(CursorContext cursorContext) {
        if (this.descriptor.isUnique()) {
            return this.uniqueSampler.result();
        }
        return this.buildNonUniqueIndexSample(cursorContext);
    }

    void flushTreeAndMarkAs(byte state, FileFlushEvent flushEvent, CursorContext cursorContext) {
        this.tree.checkpoint((Consumer)new NativeIndexHeaderWriter(state), flushEvent, cursorContext);
    }

    IndexSample buildNonUniqueIndexSample(CursorContext cursorContext) {
        return new FullScanNonUniqueIndexSampler(this.tree, this.layout).sample(cursorContext, new AtomicBoolean());
    }

    private void markTreeAsFailed(FileFlushEvent flushEvent, CursorContext cursorContext) {
        Preconditions.checkState((this.failureBytes != null ? 1 : 0) != 0, (String)"markAsFailed hasn't been called, populator not actually failed?");
        this.tree.checkpoint((Consumer)new FailureHeaderWriter(this.failureBytes), flushEvent, cursorContext);
    }

    private void processUpdates(Iterable<? extends IndexEntryUpdate<?>> indexEntryUpdates, ConflictDetectingValueMerger<KEY, Value[]> conflictDetector, CursorContext cursorContext) throws IndexEntryConflictException {
        try (Writer writer = this.tree.writer(1, cursorContext);){
            for (IndexEntryUpdate<?> indexEntryUpdate : indexEntryUpdates) {
                NativeIndexUpdater.processUpdate(this.treeKey, (ValueIndexEntryUpdate)indexEntryUpdate, writer, conflictDetector, this.ignoreStrategy);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void updateUniqueSample(IndexEntryUpdate<?> update) {
        switch (update.updateMode()) {
            case ADDED: {
                this.uniqueSampler.increment(1L);
                break;
            }
            case REMOVED: {
                this.uniqueSampler.increment(-1L);
                break;
            }
            case CHANGED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported update mode type:" + String.valueOf(update.updateMode()));
            }
        }
    }

    private void assertNotDropped() {
        if (this.dropped) {
            throw new IllegalStateException("Populator has already been dropped.");
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Populator has already been closed.");
        }
    }

    private void ensureTreeInstantiated() {
        if (this.tree == null) {
            this.instantiateTree(RecoveryCleanupWorkCollector.ignore());
        }
    }

    private void assertPopulatorOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Populator has already been closed.");
        }
    }
}

