/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.util.DurationLogger;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;

class OnlineIndexSamplingJob
implements IndexSamplingJob {
    private static final String INDEX_SAMPLER_TAG = "indexSampler";
    private final long indexId;
    private final IndexProxy indexProxy;
    private final IndexStatisticsStore indexStatisticsStore;
    private final InternalLog log;
    private final String indexUserDescription;
    private final String indexName;
    private final CursorContextFactory contextFactory;

    OnlineIndexSamplingJob(long indexId, IndexProxy indexProxy, IndexStatisticsStore indexStatisticsStore, String indexUserDescription, String indexName, InternalLogProvider logProvider, CursorContextFactory contextFactory) {
        this.indexId = indexId;
        this.indexProxy = indexProxy;
        this.indexStatisticsStore = indexStatisticsStore;
        this.log = logProvider.getLog(this.getClass());
        this.indexUserDescription = indexUserDescription;
        this.indexName = indexName;
        this.contextFactory = contextFactory;
    }

    @Override
    public long indexId() {
        return this.indexId;
    }

    @Override
    public String indexName() {
        return this.indexName;
    }

    @Override
    public void run(AtomicBoolean stopped) {
        try (DurationLogger durationLogger = new DurationLogger(this.log, "Sampling index " + this.indexUserDescription);){
            try (ValueIndexReader reader = this.indexProxy.newValueReader();
                 CursorContext cursorContext = this.contextFactory.create(INDEX_SAMPLER_TAG);
                 IndexSampler sampler = reader.createSampler();){
                IndexSample sample = sampler.sampleIndex(cursorContext, stopped);
                boolean wasInterrupted = stopped.get();
                if (this.indexProxy.getState() == InternalIndexState.ONLINE && !wasInterrupted) {
                    this.indexStatisticsStore.setSampleStats(this.indexId, sample);
                    durationLogger.markAsFinished();
                    this.log.debug(String.format("Sampled index %s with %d unique values in sample of avg size %d taken from index containing %d entries", this.indexUserDescription, sample.uniqueValues(), sample.sampleSize(), sample.indexSize()));
                } else {
                    durationLogger.markAsAborted(wasInterrupted ? "Sampling job aborted" : "Index no longer ONLINE");
                }
            }
            catch (IndexNotFoundKernelException e) {
                durationLogger.markAsAborted("Attempted to sample missing/already deleted index " + this.indexUserDescription);
            }
        }
    }
}

