/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaReadCore;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.token.api.NamedToken;

public abstract class TokenAccess<R> {
    public static final TokenAccess<RelationshipType> RELATIONSHIP_TYPES = new TokenAccess<RelationshipType>(){

        @Override
        Iterator<NamedToken> tokens(TokenRead read) {
            return read.relationshipTypesGetAllTokens();
        }

        @Override
        RelationshipType token(NamedToken token) {
            return RelationshipType.withName((String)token.name());
        }

        @Override
        boolean inUse(Read read, SchemaReadCore schemaReadCore, int tokenId) {
            return TokenAccess.hasAny(schemaReadCore.indexesGetForRelationshipType(tokenId)) || TokenAccess.hasAny(schemaReadCore.constraintsGetForRelationshipType(tokenId)) || read.countsForRelationship(-1, tokenId, -1) > 0L;
        }
    };
    public static final TokenAccess<Label> LABELS = new TokenAccess<Label>(){

        @Override
        Iterator<NamedToken> tokens(TokenRead read) {
            return read.labelsGetAllTokens();
        }

        @Override
        Label token(NamedToken token) {
            return Label.label((String)token.name());
        }

        @Override
        boolean inUse(Read read, SchemaReadCore schemaReadCore, int tokenId) {
            return TokenAccess.hasAny(schemaReadCore.indexesGetForLabel(tokenId)) || TokenAccess.hasAny(schemaReadCore.constraintsGetForLabel(tokenId)) || read.countsForNode(tokenId) > 0L;
        }
    };
    public static final TokenAccess<String> PROPERTY_KEYS = new TokenAccess<String>(){

        @Override
        Iterator<NamedToken> tokens(TokenRead read) {
            return read.propertyKeyGetAllTokens();
        }

        @Override
        String token(NamedToken token) {
            return token.name();
        }

        @Override
        boolean inUse(Read read, SchemaReadCore schemaReadCore, int tokenId) {
            return true;
        }
    };

    private static <T> Iterator<T> inUse(final Read dataRead, SchemaRead schemaRead, TokenRead tokenRead, TokenAccess<T> access) {
        final SchemaReadCore schemaReadCore = schemaRead.snapshot();
        return new TokenIterator<T>(tokenRead, access){

            protected T fetchNextOrNull() {
                while (this.tokens.hasNext()) {
                    NamedToken token = (NamedToken)this.tokens.next();
                    if (!this.access.inUse(dataRead, schemaReadCore, token.id())) continue;
                    return this.access.token(token);
                }
                return null;
            }
        };
    }

    private static <T> Iterator<T> all(TokenRead tokenRead, TokenAccess<T> access) {
        return new TokenIterator<T>(tokenRead, access){

            protected T fetchNextOrNull() {
                if (this.tokens.hasNext()) {
                    return this.access.token((NamedToken)this.tokens.next());
                }
                return null;
            }
        };
    }

    public final Iterator<R> inUse(Read dataRead, SchemaRead schemaRead, TokenRead tokenRead) {
        return TokenAccess.inUse(dataRead, schemaRead, tokenRead, this);
    }

    public final Iterator<R> all(TokenRead tokenRead) {
        return TokenAccess.all(tokenRead, this);
    }

    private static boolean hasAny(Iterator<?> iter) {
        if (iter.hasNext()) {
            return true;
        }
        if (iter instanceof Resource) {
            ((Resource)iter).close();
        }
        return false;
    }

    abstract Iterator<NamedToken> tokens(TokenRead var1);

    abstract R token(NamedToken var1);

    abstract boolean inUse(Read var1, SchemaReadCore var2, int var3);

    private static abstract class TokenIterator<T>
    extends PrefetchingIterator<T> {
        protected final TokenAccess<T> access;
        protected final Iterator<NamedToken> tokens;

        private TokenIterator(TokenRead tokenRead, TokenAccess<T> access) {
            this.access = access;
            this.tokens = access.tokens(tokenRead);
        }
    }
}

