/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import java.util.Locale;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class IncompatibleGraphTypeDependenceException
extends SchemaKernelException {
    public IncompatibleGraphTypeDependenceException(ConstraintDescriptor constraint, ConstraintDescriptor preExistingConstraint, TokenNameLookup tokenNameLookup) {
        super((Status)Status.Schema.ConstraintCreationFailed, IncompatibleGraphTypeDependenceException.constructUserMessage(constraint, preExistingConstraint, tokenNameLookup));
    }

    private static String constructUserMessage(ConstraintDescriptor constraint, ConstraintDescriptor preExistingConstraint, TokenNameLookup tokenNameLookup) {
        return String.format("Graph Type %s constraint: %s is incompatible with Graph Type %s %s due to differing Graph Type dependence.", constraint.graphTypeDependence().name().toLowerCase(Locale.ROOT), constraint.schema().userDescription(tokenNameLookup), preExistingConstraint.graphTypeDependence().name().toLowerCase(Locale.ROOT), preExistingConstraint.userDescription(tokenNameLookup));
    }
}

