/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.kernel.api.exceptions.Status;

public class EquivalentSchemaRuleAlreadyExistsException
extends SchemaKernelException {
    private static final String EQUIVALENT_INDEX = "An equivalent index already exists, '%s'.";
    private static final String EQUIVALENT_CONSTRAINT = "An equivalent constraint already exists, '%s'.";

    public EquivalentSchemaRuleAlreadyExistsException(SchemaRule schemaRule, SchemaKernelException.OperationContext context, TokenNameLookup tokenNameLookup) {
        super((Status)Status.Schema.EquivalentSchemaRuleAlreadyExists, EquivalentSchemaRuleAlreadyExistsException.constructUserMessage(context, tokenNameLookup, schemaRule));
    }

    public EquivalentSchemaRuleAlreadyExistsException(ErrorGqlStatusObject gqlStatusObject, SchemaRule schemaRule, SchemaKernelException.OperationContext context, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, (Status)Status.Schema.EquivalentSchemaRuleAlreadyExists, EquivalentSchemaRuleAlreadyExistsException.constructUserMessage(context, tokenNameLookup, schemaRule));
    }

    private static String constructUserMessage(SchemaKernelException.OperationContext context, TokenNameLookup tokenNameLookup, SchemaRule schemaRule) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case SchemaKernelException.OperationContext.INDEX_CREATION -> String.format(EQUIVALENT_INDEX, schemaRule.userDescription(tokenNameLookup));
            case SchemaKernelException.OperationContext.CONSTRAINT_CREATION -> String.format(EQUIVALENT_CONSTRAINT, schemaRule.userDescription(tokenNameLookup));
        };
    }
}

