/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.internal.helpers.MathUtil;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeAccessProvider;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.entry.LogSegments;
import org.neo4j.kernel.impl.transaction.log.files.LastClosedPositionProvider;
import org.neo4j.kernel.impl.transaction.log.files.LastCommittedTransactionIdProvider;
import org.neo4j.kernel.impl.transaction.log.files.LogFileVersionTracker;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionRepositoryProvider;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.HealthEventGenerator;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.ReadOnlyLogVersionRepository;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdProvider;
import org.neo4j.storageengine.api.TransactionIdStore;

public class LogFilesBuilder {
    private boolean readOnlyStores;
    private PageCache pageCache;
    private StorageEngineFactory storageEngineFactory;
    private CommandReaderFactory commandReaderFactory;
    private DatabaseLayout databaseLayout;
    private Path logsDirectory;
    private Config config;
    private Long rotationThreshold;
    private InternalLogProvider logProvider = NullLogProvider.getInstance();
    private DependencyResolver dependencies;
    private FileSystemAbstraction fileSystem;
    private LogVersionRepository logVersionRepository;
    private LogFileVersionTracker logFileVersionTracker;
    private TransactionIdStore transactionIdStore;
    private LongSupplier lastCommittedTransactionIdSupplier;
    private ThrowingSupplier<LogPosition, IOException> lastClosedPositionSupplier;
    private boolean fileBasedOperationsOnly;
    private DatabaseTracers databaseTracers = DatabaseTracers.EMPTY;
    private MemoryTracker memoryTracker = EmptyMemoryTracker.INSTANCE;
    private DatabaseHealth databaseHealth;
    private Clock clock;
    private Monitors monitors;
    private StoreId storeId;
    private NativeAccess nativeAccess;
    private KernelVersionProvider kernelVersionProvider = KernelVersionProvider.THROWING_PROVIDER;
    private LogTailMetadata externalLogTail;
    private int envelopeSegmentBlockSizeBytes = LogSegments.DEFAULT_LOG_SEGMENT_SIZE;
    private int bufferSizeBytes;
    private boolean readOnlyLogs;

    private LogFilesBuilder() {
    }

    public static LogFilesBuilder builder(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, KernelVersionProvider kernelVersionProvider) {
        LogFilesBuilder filesBuilder = new LogFilesBuilder();
        filesBuilder.databaseLayout = databaseLayout;
        filesBuilder.fileSystem = fileSystem;
        filesBuilder.kernelVersionProvider = kernelVersionProvider;
        return filesBuilder;
    }

    public static LogFilesBuilder builder(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem) {
        LogFilesBuilder filesBuilder = new LogFilesBuilder();
        filesBuilder.databaseLayout = databaseLayout;
        filesBuilder.fileSystem = fileSystem;
        return filesBuilder;
    }

    public static LogFilesBuilder activeFilesBuilder(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, PageCache pageCache, KernelVersionProvider kernelVersionProvider) {
        LogFilesBuilder builder = LogFilesBuilder.builder(databaseLayout, fileSystem, kernelVersionProvider);
        builder.pageCache = pageCache;
        builder.readOnlyStores = true;
        return builder;
    }

    public static LogFilesBuilder readOnlyBuilder(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, PageCache pageCache, KernelVersionProvider kernelVersionProvider) {
        LogFilesBuilder builder = new LogFilesBuilder();
        builder.databaseLayout = databaseLayout;
        builder.fileSystem = fileSystem;
        builder.pageCache = pageCache;
        builder.kernelVersionProvider = kernelVersionProvider;
        builder.readOnlyStores = true;
        builder.readOnlyLogs = true;
        return builder;
    }

    public static LogFilesBuilder logFilesBasedOnlyBuilder(Path logsDirectory, FileSystemAbstraction fileSystem) {
        LogFilesBuilder builder = new LogFilesBuilder();
        builder.logsDirectory = logsDirectory;
        builder.databaseLayout = DatabaseLayout.ofFlat((Path)logsDirectory);
        builder.fileSystem = fileSystem;
        builder.fileBasedOperationsOnly = true;
        return builder;
    }

    public LogFilesBuilder withLastClosedTransactionPositionSupplier(ThrowingSupplier<LogPosition, IOException> lastClosedPositionSupplier) {
        this.lastClosedPositionSupplier = lastClosedPositionSupplier;
        return this;
    }

    public LogFilesBuilder withLogVersionRepository(LogVersionRepository logVersionRepository) {
        this.logVersionRepository = logVersionRepository;
        return this;
    }

    public LogFilesBuilder withLogFileVersionTracker(LogFileVersionTracker logFileVersionTracker) {
        this.logFileVersionTracker = logFileVersionTracker;
        return this;
    }

    public LogFilesBuilder withTransactionIdStore(TransactionIdStore transactionIdStore) {
        this.transactionIdStore = transactionIdStore;
        return this;
    }

    public LogFilesBuilder withExternalLogTailMetadata(LogTailMetadata logTailMetadata) {
        this.externalLogTail = logTailMetadata;
        return this;
    }

    public LogFilesBuilder withLogProvider(InternalLogProvider logProvider) {
        this.logProvider = logProvider;
        return this;
    }

    public LogFilesBuilder withLastCommittedTransactionIdSupplier(LongSupplier transactionIdSupplier) {
        this.lastCommittedTransactionIdSupplier = transactionIdSupplier;
        return this;
    }

    public LogFilesBuilder withConfig(Config config) {
        this.config = config;
        return this;
    }

    public LogFilesBuilder withMonitors(Monitors monitors) {
        this.monitors = monitors;
        return this;
    }

    public LogFilesBuilder withRotationThreshold(long rotationThreshold) {
        this.rotationThreshold = rotationThreshold;
        return this;
    }

    public LogFilesBuilder withDependencies(DependencyResolver dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public LogFilesBuilder withDatabaseTracers(DatabaseTracers databaseTracers) {
        this.databaseTracers = databaseTracers;
        return this;
    }

    public LogFilesBuilder withMemoryTracker(MemoryTracker memoryTracker) {
        this.memoryTracker = memoryTracker;
        return this;
    }

    public LogFilesBuilder withNativeAccess(NativeAccess nativeAccess) {
        this.nativeAccess = nativeAccess;
        return this;
    }

    public LogFilesBuilder withStoreId(StoreId storeId) {
        this.storeId = storeId;
        return this;
    }

    public LogFilesBuilder withClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public LogFilesBuilder withDatabaseHealth(DatabaseHealth databaseHealth) {
        this.databaseHealth = databaseHealth;
        return this;
    }

    public LogFilesBuilder withStorageEngineFactory(StorageEngineFactory storageEngineFactory) {
        this.storageEngineFactory = storageEngineFactory;
        return this;
    }

    public LogFilesBuilder withCommandReaderFactory(CommandReaderFactory commandReaderFactory) {
        this.commandReaderFactory = commandReaderFactory;
        return this;
    }

    public LogFilesBuilder withLogsDirectory(Path logsDirectory) {
        this.logsDirectory = logsDirectory;
        return this;
    }

    public LogFilesBuilder withEnvelopeSegmentBlockSizeBytes(int envelopeSegmentBlockSizeBytes) {
        this.envelopeSegmentBlockSizeBytes = envelopeSegmentBlockSizeBytes;
        return this;
    }

    public LogFilesBuilder withBufferSizeBytes(int overrideBufferSizeBytes) {
        this.bufferSizeBytes = overrideBufferSizeBytes;
        return this;
    }

    public LogFilesBuilder withKernelVersionProvider(KernelVersionProvider kernelVersionProvider) {
        this.kernelVersionProvider = kernelVersionProvider;
        return this;
    }

    public LogFiles build() throws IOException {
        TransactionLogFilesContext filesContext = this.buildContext();
        Path logsDirectory = this.getLogsDirectory();
        filesContext.getFileSystem().mkdirs(logsDirectory);
        return new TransactionLogFiles(logsDirectory, "neostore.transaction.db", filesContext);
    }

    private Path getLogsDirectory() {
        return Objects.requireNonNullElseGet(this.logsDirectory, () -> this.databaseLayout.getTransactionLogsDirectory());
    }

    TransactionLogFilesContext buildContext() {
        if (this.config == null) {
            this.config = Config.defaults();
        }
        Objects.requireNonNull(this.fileSystem);
        Supplier<StoreId> storeIdSupplier = this.getStoreId();
        LogVersionRepositoryProvider logVersionRepositorySupplier = this.getLogVersionRepositoryProvider();
        LogFileVersionTracker versionTracker = this.getLogFileVersionTracker();
        LastCommittedTransactionIdProvider lastCommittedIdSupplier = this.lastCommittedIdProvider();
        LongSupplier committingTransactionIdSupplier = this.committingIdSupplier();
        LastClosedPositionProvider lastClosedTransactionPositionProvider = this.closePositionProvider();
        AtomicLong rotationThreshold = this.getRotationThresholdAndRegisterForUpdates();
        AtomicBoolean tryPreallocateTransactionLogs = this.getTryToPreallocateTransactionLogs();
        NativeAccess nativeAccess = this.getNativeAccess();
        Monitors monitors = this.getMonitors();
        DatabaseHealth health = this.getDatabaseHealth();
        Clock clock = this.getClock();
        return new TransactionLogFilesContext(rotationThreshold, tryPreallocateTransactionLogs, this.commandReaderFactory(), lastCommittedIdSupplier, committingTransactionIdSupplier, lastClosedTransactionPositionProvider, logVersionRepositorySupplier, versionTracker, this.fileSystem, this.logProvider, this.databaseTracers, storeIdSupplier, nativeAccess, this.memoryTracker, monitors, (Boolean)this.config.get(GraphDatabaseInternalSettings.fail_on_corrupted_log_files), health, this.kernelVersionProvider, clock, this.databaseLayout.getDatabaseName(), this.config, this.externalLogTail, new BinarySupportedKernelVersions(this.config), this.readOnlyLogs, this.envelopeSegmentBlockSizeBytes, this.getBufferSizeBytes());
    }

    private CommandReaderFactory commandReaderFactory() {
        if (this.commandReaderFactory != null) {
            return this.commandReaderFactory;
        }
        if (this.fileBasedOperationsOnly) {
            return CommandReaderFactory.NO_COMMANDS;
        }
        return this.storageEngineFactory().commandReaderFactory();
    }

    private StorageEngineFactory storageEngineFactory() {
        if (this.storageEngineFactory == null) {
            this.storageEngineFactory = (StorageEngineFactory)StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)this.fileSystem, (DatabaseLayout)this.databaseLayout).orElseThrow();
        }
        return this.storageEngineFactory;
    }

    private Clock getClock() {
        if (this.clock != null) {
            return this.clock;
        }
        return Clock.systemUTC();
    }

    private DatabaseHealth getDatabaseHealth() {
        if (this.databaseHealth != null) {
            return this.databaseHealth;
        }
        if (this.dependencies != null) {
            return (DatabaseHealth)this.dependencies.resolveDependency(DatabaseHealth.class);
        }
        return new DatabaseHealth(HealthEventGenerator.NO_OP, this.logProvider.getLog(DatabaseHealth.class));
    }

    private Monitors getMonitors() {
        if (this.monitors == null) {
            return new Monitors();
        }
        return this.monitors;
    }

    private NativeAccess getNativeAccess() {
        if (this.nativeAccess != null) {
            return this.nativeAccess;
        }
        if (this.dependencies != null && this.dependencies.containsDependency(NativeAccess.class)) {
            return (NativeAccess)this.dependencies.resolveDependency(NativeAccess.class);
        }
        return NativeAccessProvider.getNativeAccess();
    }

    private int getBufferSizeBytes() {
        if (this.bufferSizeBytes == 0) {
            return (int)MathUtil.roundUp((long)((Long)this.config.get(GraphDatabaseSettings.transaction_log_buffer_size)), (long)this.envelopeSegmentBlockSizeBytes);
        }
        return (int)MathUtil.roundUp((long)this.bufferSizeBytes, (long)this.envelopeSegmentBlockSizeBytes);
    }

    private AtomicLong getRotationThresholdAndRegisterForUpdates() {
        if (this.rotationThreshold != null) {
            return new AtomicLong(this.guaranteeAtLeastTwoSegments(MathUtil.roundUp((long)this.rotationThreshold, (long)this.envelopeSegmentBlockSizeBytes)));
        }
        if (this.readOnlyStores) {
            return new AtomicLong(MathUtil.roundUp((long)(Long.MAX_VALUE - (long)this.envelopeSegmentBlockSizeBytes), (long)this.envelopeSegmentBlockSizeBytes));
        }
        AtomicLong configThreshold = new AtomicLong(this.guaranteeAtLeastTwoSegments(MathUtil.roundUp((long)((Long)this.config.get(GraphDatabaseSettings.logical_log_rotation_threshold)), (long)this.envelopeSegmentBlockSizeBytes)));
        this.config.addListener(GraphDatabaseSettings.logical_log_rotation_threshold, (prev, update) -> configThreshold.set(this.guaranteeAtLeastTwoSegments(MathUtil.roundUp((long)update, (long)this.envelopeSegmentBlockSizeBytes))));
        return configThreshold;
    }

    private long guaranteeAtLeastTwoSegments(long rotationThreshold) {
        return Math.max(rotationThreshold, (long)this.envelopeSegmentBlockSizeBytes * 2L);
    }

    private AtomicBoolean getTryToPreallocateTransactionLogs() {
        if (this.readOnlyStores) {
            return new AtomicBoolean(false);
        }
        AtomicBoolean tryToPreallocate = new AtomicBoolean((Boolean)this.config.get(GraphDatabaseSettings.preallocate_logical_logs));
        this.config.addListener(GraphDatabaseSettings.preallocate_logical_logs, (prev, update) -> {
            String logMessage = "Updating " + GraphDatabaseSettings.preallocate_logical_logs.name() + " from " + prev + " to " + update;
            this.logProvider.getLog(LogFiles.class).debug(logMessage);
            tryToPreallocate.set((boolean)update);
        });
        return tryToPreallocate;
    }

    private LogVersionRepositoryProvider getLogVersionRepositoryProvider() {
        if (this.logVersionRepository != null) {
            return any -> this.logVersionRepository;
        }
        if (this.fileBasedOperationsOnly) {
            return any -> {
                throw new UnsupportedOperationException("Current version of log files can't perform any operation that require availability of log version repository. Please build full version of log files to be able to use them.");
            };
        }
        if (this.readOnlyStores) {
            Objects.requireNonNull(this.pageCache, "Read only log files require page cache to be able to read current log version.");
            Objects.requireNonNull(this.databaseLayout, "Store directory is required.");
            return new ReadOnlyLogVersionRepositoryProvider();
        }
        Objects.requireNonNull(this.dependencies, LogVersionRepository.class.getSimpleName() + " is required. Please provide an instance or a dependencies where it can be found.");
        return new SupplierLogVersionRepositoryProvider(this.dependencies.provideDependency(LogVersionRepository.class));
    }

    private LogFileVersionTracker getLogFileVersionTracker() {
        if (this.logFileVersionTracker != null) {
            return this.logFileVersionTracker;
        }
        if (this.dependencies != null && this.dependencies.containsDependency(LogFileVersionTracker.class)) {
            return this.resolveDependency(LogFileVersionTracker.class);
        }
        return LogFileVersionTracker.NO_OP;
    }

    private LastCommittedTransactionIdProvider lastCommittedIdProvider() {
        if (this.lastCommittedTransactionIdSupplier != null) {
            return new LongSupplierLastCommittedTransactionIdProvider(this.lastCommittedTransactionIdSupplier);
        }
        if (this.transactionIdStore != null) {
            return new LongSupplierLastCommittedTransactionIdProvider(() -> ((TransactionIdStore)this.transactionIdStore).getLastCommittedTransactionId());
        }
        if (this.fileBasedOperationsOnly) {
            return any -> {
                throw new UnsupportedOperationException("Current version of log files can't perform any operation that require availability of transaction id store. Please build full version of log files to be able to use them.");
            };
        }
        if (this.readOnlyStores) {
            Objects.requireNonNull(this.pageCache, "Read only log files require page cache to be able to read committed transaction info from store store.");
            Objects.requireNonNull(this.databaseLayout, "Store directory is required.");
            return new ReadOnlyLastCommittedTransactionIdProvider();
        }
        Objects.requireNonNull(this.dependencies, TransactionIdStore.class.getSimpleName() + " is required. Please provide an instance or a dependencies where it can be found.");
        return new LongSupplierLastCommittedTransactionIdProvider(() -> this.resolveDependency(TransactionIdStore.class).getLastCommittedTransactionId());
    }

    private LastClosedPositionProvider closePositionProvider() {
        if (this.lastClosedPositionSupplier != null) {
            return any -> (LogPosition)this.lastClosedPositionSupplier.get();
        }
        if (this.transactionIdStore != null) {
            return any -> this.transactionIdStore.getLastClosedTransaction().logPosition();
        }
        if (this.fileBasedOperationsOnly) {
            return any -> {
                throw new UnsupportedOperationException("Current version of log files can't perform any operation that require availability of transaction id store. Please build full version of log files to be able to use them.");
            };
        }
        if (this.readOnlyStores) {
            Objects.requireNonNull(this.pageCache, "Read only log files require page cache to be able to read committed transaction info from store store.");
            Objects.requireNonNull(this.databaseLayout, "Store directory is required.");
            return logFiles -> logFiles.getTailMetadata().getLastTransactionLogPosition();
        }
        Objects.requireNonNull(this.dependencies, TransactionIdStore.class.getSimpleName() + " is required. Please provide an instance or a dependencies where it can be found.");
        return any -> this.resolveDependency(TransactionIdStore.class).getLastClosedTransaction().logPosition();
    }

    private LongSupplier committingIdSupplier() {
        if (this.transactionIdStore != null) {
            return () -> ((TransactionIdStore)this.transactionIdStore).committingTransactionId();
        }
        if (this.fileBasedOperationsOnly) {
            return () -> {
                throw new UnsupportedOperationException("Current version of log files can't perform any operation that require availability of transaction id store. Please build full version of log files to be able to use them.");
            };
        }
        if (this.readOnlyStores) {
            Objects.requireNonNull(this.pageCache, "Read only log files require page cache to be able to read committed transaction info from store store.");
            Objects.requireNonNull(this.databaseLayout, "Store directory is required.");
            return () -> {
                throw new UnsupportedOperationException("Read only log files can't have any transaction commit in progress.");
            };
        }
        Objects.requireNonNull(this.dependencies, TransactionIdStore.class.getSimpleName() + " is required. Please provide an instance or a dependencies where it can be found.");
        return () -> this.resolveDependency(TransactionIdStore.class).committingTransactionId();
    }

    private Supplier<StoreId> getStoreId() {
        if (this.storeId != null) {
            return () -> this.storeId;
        }
        if (this.fileBasedOperationsOnly) {
            return () -> {
                throw new UnsupportedOperationException("Current version of log files can't perform any operation that require availability of store id. Please build full version of log files to be able to use them.");
            };
        }
        return () -> this.resolveDependency(StoreIdProvider.class).getStoreId();
    }

    private <T> T resolveDependency(Class<T> clazz) {
        return (T)this.dependencies.resolveDependency(clazz);
    }

    private static class ReadOnlyLogVersionRepositoryProvider
    implements LogVersionRepositoryProvider {
        private ReadOnlyLogVersionRepositoryProvider() {
        }

        @Override
        public LogVersionRepository logVersionRepository(LogFiles logFiles) {
            return new ReadOnlyLogVersionRepository(logFiles.getTailMetadata());
        }
    }

    private static class SupplierLogVersionRepositoryProvider
    implements LogVersionRepositoryProvider {
        private final Supplier<LogVersionRepository> supplier;

        SupplierLogVersionRepositoryProvider(Supplier<LogVersionRepository> supplier) {
            this.supplier = supplier;
        }

        @Override
        public LogVersionRepository logVersionRepository(LogFiles logFiles) {
            return this.supplier.get();
        }
    }

    private static class LongSupplierLastCommittedTransactionIdProvider
    implements LastCommittedTransactionIdProvider {
        private final LongSupplier idSupplier;

        LongSupplierLastCommittedTransactionIdProvider(LongSupplier idSupplier) {
            this.idSupplier = idSupplier;
        }

        @Override
        public long getLastCommittedTransactionId(LogFiles logFiles) {
            return this.idSupplier.getAsLong();
        }
    }

    private static class ReadOnlyLastCommittedTransactionIdProvider
    implements LastCommittedTransactionIdProvider {
        private ReadOnlyLastCommittedTransactionIdProvider() {
        }

        @Override
        public long getLastCommittedTransactionId(LogFiles logFiles) {
            return logFiles.getTailMetadata().getLastCommittedTransaction().transactionId();
        }
    }
}

