/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.mutable.MutableInt;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.internal.kernel.api.TokenSet;

public class Labels
implements TokenSet {
    private final int[] labelIds;

    private Labels(int[] labelIds) {
        this.labelIds = labelIds;
    }

    public static Labels from(int ... labels) {
        return new Labels(labels);
    }

    static Labels from(IntSet set) {
        return new Labels(set.toArray());
    }

    static Labels from(LongSet set) {
        int[] labelIds = new int[set.size()];
        MutableInt index = new MutableInt();
        set.each((LongProcedure & Serializable)element -> {
            labelIds[index.getAndIncrement()] = (int)element;
        });
        return new Labels(labelIds);
    }

    public int numberOfTokens() {
        return this.labelIds.length;
    }

    public int token(int offset) {
        return this.labelIds[offset];
    }

    public boolean contains(int token) {
        for (int label : this.labelIds) {
            if (label != token) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Labels" + Arrays.toString(this.labelIds);
    }

    public int[] all() {
        return this.labelIds;
    }
}

