/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.AbstractResourceIterable;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.impl.api.CloseableResourceManager;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.coreapi.DataLookup;
import org.neo4j.kernel.impl.coreapi.EntityLocker;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionExceptionMapper;
import org.neo4j.kernel.impl.coreapi.internal.CursorIterator;
import org.neo4j.kernel.impl.coreapi.schema.SchemaImpl;
import org.neo4j.kernel.impl.query.QueryExecutionConfiguration;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.impl.traversal.BidirectionalTraversalDescriptionImpl;
import org.neo4j.kernel.impl.traversal.MonoDirectionalTraversalDescription;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.virtual.MapValue;

public class TransactionImpl
extends DataLookup
implements InternalTransaction {
    private final TokenHolders tokenHolders;
    private final TransactionalContextFactory contextFactory;
    private final DatabaseAvailabilityGuard availabilityGuard;
    private final QueryExecutionEngine executionEngine;
    private final Consumer<Status> terminationCallback;
    private final TransactionExceptionMapper exceptionMapper;
    private final ElementIdMapper elementIdMapper;
    private final ResourceTracker coreApiResourceTracker;
    private KernelTransaction transaction;
    private boolean closed;

    public TransactionImpl(TokenHolders tokenHolders, TransactionalContextFactory contextFactory, DatabaseAvailabilityGuard availabilityGuard, QueryExecutionEngine executionEngine, KernelTransaction transaction, ElementIdMapper elementIdMapper) {
        this(tokenHolders, contextFactory, availabilityGuard, executionEngine, transaction, new CloseableResourceManager(), null, null, elementIdMapper);
    }

    public TransactionImpl(TokenHolders tokenHolders, TransactionalContextFactory contextFactory, DatabaseAvailabilityGuard availabilityGuard, QueryExecutionEngine executionEngine, KernelTransaction transaction, ResourceTracker coreApiResourceTracker, Consumer<Status> terminationCallback, TransactionExceptionMapper exceptionMapper, ElementIdMapper elementIdMapper) {
        this.tokenHolders = tokenHolders;
        this.contextFactory = contextFactory;
        this.availabilityGuard = availabilityGuard;
        this.executionEngine = executionEngine;
        this.coreApiResourceTracker = coreApiResourceTracker;
        this.terminationCallback = terminationCallback;
        this.exceptionMapper = exceptionMapper;
        this.elementIdMapper = elementIdMapper;
        this.setTransaction(transaction);
    }

    public void registerCloseableResource(AutoCloseable closeableResource) {
        this.coreApiResourceTracker.registerCloseableResource(closeableResource);
    }

    public void unregisterCloseableResource(AutoCloseable closeableResource) {
        this.coreApiResourceTracker.unregisterCloseableResource(closeableResource);
    }

    public void commit() {
        this.commit(KernelTransaction.NO_MONITOR);
    }

    public void commit(KernelTransaction.KernelTransactionMonitor kernelTransactionMonitor) {
        this.safeTerminalOperation(transaction -> transaction.commit(kernelTransactionMonitor));
    }

    public void rollback() {
        if (this.isOpen()) {
            this.safeTerminalOperation(KernelTransaction::rollback);
        }
    }

    public Node createNode() {
        KernelTransaction ktx = this.kernelTransaction();
        try {
            return this.newNodeEntity(ktx.dataWrite().nodeCreate());
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public Node createNode(Label ... labels) {
        KernelTransaction ktx = this.kernelTransaction();
        try {
            TokenWrite tokenWrite = ktx.tokenWrite();
            int[] labelIds = new int[labels.length];
            String[] labelNames = new String[labels.length];
            for (int i = 0; i < labelNames.length; ++i) {
                labelNames[i] = labels[i].name();
            }
            tokenWrite.labelGetOrCreateForNames(labelNames, labelIds);
            Write write = ktx.dataWrite();
            long nodeId = write.nodeCreateWithLabels(labelIds);
            return this.newNodeEntity(nodeId);
        }
        catch (ConstraintValidationException e) {
            throw new ConstraintViolationException("Unable to add label.", (Throwable)e);
        }
        catch (SchemaKernelException e) {
            throw new IllegalArgumentException(e);
        }
        catch (KernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public Result execute(String query) throws QueryExecutionException {
        return this.execute(query, Collections.emptyMap());
    }

    public Result execute(String query, Map<String, Object> parameters) throws QueryExecutionException {
        return this.execute(this, query, ValueUtils.asParameterMapValue(parameters));
    }

    private Result execute(InternalTransaction transaction, String query, MapValue parameters) throws QueryExecutionException {
        this.checkInTransaction();
        TransactionalContext context = this.contextFactory.newContext(transaction, query, parameters, QueryExecutionConfiguration.DEFAULT_CONFIG);
        try {
            this.availabilityGuard.assertDatabaseAvailable();
            return this.executionEngine.executeQuery(query, parameters, context, false);
        }
        catch (UnavailableException ue) {
            throw new TransactionFailureException(ue.getMessage(), (Throwable)ue, ue.status());
        }
        catch (QueryExecutionKernelException e) {
            throw e.asUserException();
        }
    }

    public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
        this.checkInTransaction();
        return new BidirectionalTraversalDescriptionImpl();
    }

    public TraversalDescription traversalDescription() {
        this.checkInTransaction();
        return new MonoDirectionalTraversalDescription();
    }

    public ResourceIterable<Node> getAllNodes() {
        this.checkInTransaction();
        return new TrackingResourceIterable<Node>(this, new NodesProvider());
    }

    public ResourceIterable<Relationship> getAllRelationships() {
        this.checkInTransaction();
        return new TrackingResourceIterable<Relationship>(this, new RelationshipsProvider());
    }

    public final void terminate() {
        this.terminate((Status)Status.Transaction.Terminated);
    }

    public void terminate(Status reason) {
        KernelTransaction ktx = this.transaction;
        if (ktx == null) {
            return;
        }
        ktx.markForTermination(reason);
        if (this.terminationCallback != null) {
            this.terminationCallback.accept(reason);
        }
    }

    public UUID getDatabaseId() {
        if (this.transaction != null) {
            return this.transaction.getDatabaseId();
        }
        return null;
    }

    public String getDatabaseName() {
        if (this.transaction != null) {
            return this.transaction.getDatabaseName();
        }
        return null;
    }

    public void close() {
        if (this.isOpen()) {
            this.safeTerminalOperation(tx -> {});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeTerminalOperation(TransactionalOperation operation) {
        if (this.closed) {
            assert (this.transaction == null) : "Closed but still have reference to kernel transaction";
            throw this.exceptionMapper.mapException((Exception)new NotInTransactionException("The transaction has been closed."));
        }
        Exception exception = null;
        try {
            try {
                this.coreApiResourceTracker.closeAllCloseableResources();
                operation.perform(this.transaction);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                if (this.transaction != null) {
                    this.transaction.close();
                }
            }
        }
        catch (Exception e) {
            exception = (Exception)Exceptions.chain((Throwable)exception, (Throwable)e);
        }
        finally {
            this.closed = true;
            this.transaction = null;
        }
        if (exception != null) {
            throw this.exceptionMapper.mapException(exception);
        }
    }

    public void setTransaction(KernelTransaction transaction) {
        this.transaction = transaction;
        transaction.bindToUserTransaction((InternalTransaction)this);
    }

    public Lock acquireWriteLock(Entity entity) {
        return EntityLocker.exclusiveLock(this.kernelTransaction(), entity);
    }

    public Lock acquireReadLock(Entity entity) {
        return EntityLocker.sharedLock(this.kernelTransaction(), entity);
    }

    public KernelTransaction kernelTransaction() {
        this.checkInTransaction();
        return this.transaction;
    }

    public KernelTransaction.Type transactionType() {
        return this.kernelTransaction().transactionType();
    }

    public SecurityContext securityContext() {
        return this.kernelTransaction().securityContext();
    }

    public ClientConnectionInfo clientInfo() {
        return this.kernelTransaction().clientInfo();
    }

    public KernelTransaction.Revertable overrideWith(SecurityContext context) {
        return this.kernelTransaction().overrideWith(context);
    }

    public Optional<Status> terminationReason() {
        KernelTransaction tx = this.transaction;
        return tx != null ? tx.getReasonIfTerminated() : Optional.empty();
    }

    public void setMetaData(Map<String, Object> txMeta) {
        this.kernelTransaction().setMetaData(txMeta);
    }

    @Override
    public RelationshipEntity newRelationshipEntity(long id) {
        return new RelationshipEntity((InternalTransaction)this, id);
    }

    public Relationship newRelationshipEntity(String elementId) {
        return new RelationshipEntity((InternalTransaction)this, this.elementIdMapper.relationshipId(elementId));
    }

    @Override
    public RelationshipEntity newRelationshipEntity(long id, long startNodeId, int typeId, long endNodeId) {
        return new RelationshipEntity(this, id, startNodeId, typeId, endNodeId);
    }

    public Relationship newRelationshipEntity(RelationshipDataAccessor cursor) {
        return new RelationshipEntity((InternalTransaction)this, cursor);
    }

    @Override
    public NodeEntity newNodeEntity(long nodeId) {
        return new NodeEntity(this, nodeId);
    }

    @Override
    protected CursorFactory cursors() {
        return this.kernelTransaction().cursors();
    }

    @Override
    protected CursorContext cursorContext() {
        return this.kernelTransaction().cursorContext();
    }

    @Override
    protected MemoryTracker memoryTracker() {
        return this.kernelTransaction().memoryTracker();
    }

    @Override
    protected QueryContext queryContext() {
        return this.kernelTransaction().queryContext();
    }

    public RelationshipType getRelationshipTypeById(int type) {
        try {
            String name = this.tokenHolders.relationshipTypeTokens().getTokenById(type).name();
            return RelationshipType.withName((String)name);
        }
        catch (TokenNotFoundException e) {
            throw new IllegalStateException("Kernel API returned non-existent relationship type: " + type, e);
        }
    }

    public Schema schema() {
        return new SchemaImpl(this.kernelTransaction());
    }

    @Override
    protected TokenRead tokenRead() {
        return this.kernelTransaction().tokenRead();
    }

    @Override
    protected SchemaRead schemaRead() {
        return this.kernelTransaction().schemaRead();
    }

    @Override
    protected Read dataRead() {
        return this.kernelTransaction().dataRead();
    }

    @Override
    protected ResourceMonitor resourceMonitor() {
        return this.coreApiResourceTracker;
    }

    public Entity validateSameDB(Entity entity) {
        return TransactionImpl.validateSameDB(this, entity);
    }

    public void checkInTransaction() {
        if (this.closed) {
            throw new NotInTransactionException("The transaction has been closed.");
        }
        if (this.transaction.isTerminated()) {
            Status terminationReason = (Status)this.transaction.getReasonIfTerminated().orElse(Status.Transaction.Terminated);
            throw new TransactionTerminatedException(terminationReason);
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public ElementIdMapper elementIdMapper() {
        return this.elementIdMapper;
    }

    @Override
    protected void performCheckBeforeOperation() {
        this.checkInTransaction();
    }

    public static Entity validateSameDB(InternalTransaction tx, Entity entity) {
        InternalTransaction internalTransaction;
        if (entity instanceof NodeEntity) {
            NodeEntity node = (NodeEntity)entity;
            internalTransaction = node.getTransaction();
        } else if (entity instanceof RelationshipEntity) {
            RelationshipEntity rel = (RelationshipEntity)entity;
            internalTransaction = rel.getTransaction();
        } else {
            return entity;
        }
        if (!internalTransaction.isOpen()) {
            throw new NotInTransactionException("The transaction of entity " + entity.getElementId() + " has been closed.");
        }
        if (internalTransaction.getDatabaseId() != tx.getDatabaseId()) {
            throw new CypherExecutionException("Can not use an entity from another database. Entity element id: " + entity.getElementId() + ", entity database: " + internalTransaction.getDatabaseName() + ", expected database: " + tx.getDatabaseName() + ".");
        }
        return entity;
    }

    @FunctionalInterface
    private static interface TransactionalOperation {
        public void perform(KernelTransaction var1) throws Exception;
    }

    private static class TrackingResourceIterable<T>
    extends AbstractResourceIterable<T> {
        private final TransactionImpl transaction;
        private final Function<TransactionImpl, ResourceIterator<T>> cursorProvider;

        private TrackingResourceIterable(TransactionImpl transaction, Function<TransactionImpl, ResourceIterator<T>> cursorProvider) {
            this.transaction = transaction;
            this.cursorProvider = cursorProvider;
            transaction.registerCloseableResource((AutoCloseable)((Object)this));
        }

        protected ResourceIterator<T> newIterator() {
            return this.cursorProvider.apply(this.transaction);
        }

        protected void onClosed() {
            this.transaction.unregisterCloseableResource((AutoCloseable)((Object)this));
        }
    }

    private static class NodesProvider
    implements Function<TransactionImpl, ResourceIterator<Node>> {
        private NodesProvider() {
        }

        @Override
        public ResourceIterator<Node> apply(TransactionImpl tx) {
            KernelTransaction ktx = tx.transaction;
            NodeCursor cursor = ktx.cursors().allocateNodeCursor(ktx.cursorContext(), ktx.memoryTracker());
            ktx.dataRead().allNodesScan(cursor);
            return new CursorIterator<NodeCursor, Node>(cursor, NodeCursor::nodeReference, c -> tx.newNodeEntity(c.nodeReference()));
        }
    }

    private static class RelationshipsProvider
    implements Function<TransactionImpl, ResourceIterator<Relationship>> {
        private RelationshipsProvider() {
        }

        @Override
        public ResourceIterator<Relationship> apply(TransactionImpl tx) {
            KernelTransaction ktx = tx.transaction;
            RelationshipScanCursor cursor = ktx.cursors().allocateRelationshipScanCursor(ktx.cursorContext(), ktx.memoryTracker());
            ktx.dataRead().allRelationshipsScan(cursor);
            return new CursorIterator<RelationshipScanCursor, Relationship>(cursor, RelationshipDataAccessor::relationshipReference, c -> tx.newRelationshipEntity((RelationshipDataAccessor)cursor));
        }
    }
}

