/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.LongFunction;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.DatabaseConfig;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingChangeListener;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.TransactionRegistry;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.store.StoreFileListing;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.DatabaseEventListeners;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.internal.DatabaseLogProvider;
import org.neo4j.logging.internal.DatabaseLogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Monitors;
import org.neo4j.resources.CpuClock;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.ElementIdMapper;

public abstract class AbstractDatabase
extends LifecycleAdapter
implements Lifecycle {
    private final Factory<DatabaseHealth> databaseHealthFactory;
    protected volatile boolean initialized;
    protected volatile boolean started;
    protected final DependencyResolver globalDependencies;
    protected final NamedDatabaseId namedDatabaseId;
    protected final DatabaseConfig databaseConfig;
    protected final DatabaseEventListeners eventListeners;
    protected final Monitors parentMonitors;
    protected final DatabaseLogService databaseLogService;
    protected final DatabaseLogProvider internalLogProvider;
    protected final DatabaseLogProvider userLogProvider;
    protected final InternalLog internalLog;
    protected final JobScheduler scheduler;
    protected final DatabaseAvailabilityGuard databaseAvailabilityGuard;
    protected DatabaseHealth databaseHealth;
    protected Dependencies databaseDependencies;
    protected LifeSupport life;
    protected SettingChangeListener<Boolean> cpuChangeListener;
    protected Monitors databaseMonitors;

    protected AbstractDatabase(DependencyResolver globalDependencies, NamedDatabaseId namedDatabaseId, DatabaseConfig databaseConfig, DatabaseEventListeners eventListeners, Monitors monitors, DatabaseLogService databaseLogService, JobScheduler scheduler, LongFunction<DatabaseAvailabilityGuard> databaseAvailabilityGuardFactory, Factory<DatabaseHealth> databaseHealthFactory) {
        this.globalDependencies = globalDependencies;
        this.namedDatabaseId = namedDatabaseId;
        this.databaseConfig = databaseConfig;
        this.eventListeners = eventListeners;
        this.parentMonitors = monitors;
        this.databaseLogService = databaseLogService;
        this.internalLogProvider = databaseLogService.getInternalLogProvider();
        this.internalLog = this.internalLogProvider.getLog(((Object)((Object)this)).getClass());
        this.userLogProvider = databaseLogService.getUserLogProvider();
        this.scheduler = scheduler;
        long availabilityGuardTimeout = ((Duration)databaseConfig.get(GraphDatabaseInternalSettings.transaction_start_timeout)).toMillis();
        this.databaseAvailabilityGuard = databaseAvailabilityGuardFactory.apply(availabilityGuardTimeout);
        this.databaseHealthFactory = databaseHealthFactory;
        this.databaseHealthFactory.newInstance();
    }

    public synchronized void init() {
        if (this.initialized) {
            return;
        }
        try {
            this.databaseDependencies = new Dependencies(this.globalDependencies);
            this.databaseMonitors = new Monitors(this.parentMonitors, (InternalLogProvider)this.internalLogProvider);
            this.life = new LifeSupport();
            this.databaseHealth = (DatabaseHealth)this.databaseHealthFactory.newInstance();
            this.databaseDependencies.satisfyDependency((Object)this);
            this.databaseDependencies.satisfyDependency((Object)this.databaseMonitors);
            this.databaseDependencies.satisfyDependency((Object)this.databaseHealth);
            this.databaseDependencies.satisfyDependency((Object)this.namedDatabaseId);
            this.databaseDependencies.satisfyDependency((Object)this.databaseConfig);
            this.databaseDependencies.satisfyDependency((Object)this.databaseLogService);
            this.databaseDependencies.satisfyDependency((Object)this.databaseAvailabilityGuard);
            this.specificInit();
            this.eventListeners.databaseCreate(this.namedDatabaseId);
            this.initialized = true;
        }
        catch (Throwable e) {
            this.handleStartupFailure(e);
        }
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.init();
        try {
            this.specificStart();
            this.life.start();
            this.eventListeners.databaseStart(this.namedDatabaseId);
            this.started = true;
            this.postStartupInit();
        }
        catch (Throwable e) {
            this.handleStartupFailure(e);
        }
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.specificStop();
        this.eventListeners.databaseShutdown(this.namedDatabaseId);
        this.life.stop();
        this.awaitAllClosingTransactions();
        this.life.shutdown();
        this.started = false;
        this.initialized = false;
    }

    public synchronized void shutdown() throws Exception {
        this.specificShutdown();
        this.safeCleanup();
        this.started = false;
        this.initialized = false;
    }

    public synchronized void drop() {
        if (this.started) {
            this.prepareToDrop();
            this.stop();
        }
        this.deleteDatabaseFilesOnDrop();
        this.eventListeners.databaseDrop(this.namedDatabaseId);
    }

    protected void handleStartupFailure(Throwable e) {
        this.databaseAvailabilityGuard.startupFailure(e);
        this.internalLog.warn("Exception occurred while starting the database. Trying to stop already started components.", e);
        try {
            this.shutdown();
        }
        catch (Exception closeException) {
            this.internalLog.error("Couldn't close database after startup failure", (Throwable)closeException);
        }
        throw new RuntimeException(e);
    }

    protected void awaitAllClosingTransactions() {
        this.internalLog.info("Waiting for closing transactions.");
        TransactionRegistry transactionRegistry = this.transactionRegistry();
        transactionRegistry.terminateTransactions();
        while (transactionRegistry.haveClosingTransaction()) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
        this.internalLog.info("All transactions are closed.");
    }

    protected AtomicReference<CpuClock> setupCpuClockAtomicReference() {
        AtomicReference<CpuClock> cpuClock = new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE);
        this.cpuChangeListener = (before, after) -> {
            if (after.booleanValue()) {
                cpuClock.set(CpuClock.CPU_CLOCK);
            } else {
                cpuClock.set(CpuClock.NOT_AVAILABLE);
            }
        };
        this.cpuChangeListener.accept(null, (Object)((Boolean)this.databaseConfig.get(GraphDatabaseSettings.track_query_cpu_time)));
        this.databaseConfig.addListener(GraphDatabaseSettings.track_query_cpu_time, this.cpuChangeListener);
        return cpuClock;
    }

    public Config getConfig() {
        return this.databaseConfig;
    }

    public DatabaseLogService getLogService() {
        return this.databaseLogService;
    }

    public DatabaseLogProvider getInternalLogProvider() {
        return this.internalLogProvider;
    }

    public Monitors getMonitors() {
        return this.databaseMonitors;
    }

    public DependencyResolver getDependencyResolver() {
        return this.databaseDependencies;
    }

    public NamedDatabaseId getNamedDatabaseId() {
        return this.namedDatabaseId;
    }

    @VisibleForTesting
    public LifeSupport getLife() {
        return this.life;
    }

    public boolean isStarted() {
        return this.started;
    }

    public DatabaseAvailabilityGuard getDatabaseAvailabilityGuard() {
        return this.databaseAvailabilityGuard;
    }

    public DatabaseHealth getDatabaseHealth() {
        return this.databaseHealth;
    }

    public abstract StoreId getStoreId();

    public abstract DatabaseLayout getDatabaseLayout();

    public abstract QueryExecutionEngine getExecutionEngine();

    public abstract Kernel getKernel();

    public abstract ResourceIterator<StoreFileMetadata> listStoreFiles(boolean var1) throws IOException;

    public abstract StoreFileListing getStoreFileListing();

    public abstract JobScheduler getScheduler();

    public abstract StoreCopyCheckPointMutex getStoreCopyCheckPointMutex();

    public abstract TokenHolders getTokenHolders();

    public abstract GraphDatabaseAPI getDatabaseAPI();

    public abstract DatabaseTracers getTracers();

    public abstract MemoryTracker getOtherDatabaseMemoryTracker();

    public abstract StorageEngineFactory getStorageEngineFactory();

    public abstract IOController getIoController();

    public abstract CursorContextFactory getCursorContextFactory();

    public abstract ElementIdMapper getElementIdMapper();

    public abstract boolean isSystem();

    public abstract void prepareToDrop();

    protected abstract void specificInit() throws Exception;

    protected abstract void specificStart() throws Exception;

    protected abstract void specificStop();

    protected abstract void specificShutdown() throws Exception;

    protected abstract TransactionRegistry transactionRegistry();

    protected abstract void postStartupInit() throws Exception;

    protected abstract void safeCleanup() throws Exception;

    protected abstract void deleteDatabaseFilesOnDrop();
}

