/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Iterator;
import java.util.function.IntUnaryOperator;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class EagerBuffer<T extends Measurable>
extends DefaultCloseListenable {
    public static final IntUnaryOperator KEEP_CONSTANT_CHUNK_SIZE = size -> size;
    public static final IntUnaryOperator GROW_NEW_CHUNKS_BY_50_PCT = size -> size + (size >> 1);
    public static final IntUnaryOperator GROW_NEW_CHUNKS_BY_100_PCT = size -> size << 1;
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(EagerBuffer.class);
    private final MemoryTracker scopedMemoryTracker;
    private final IntUnaryOperator growthStrategy;
    private final ChunkMemoryEstimator<T> memoryEstimator;
    private Chunk<T> first;
    private Chunk<T> current;
    private long size;
    private final int maxChunkSize;

    public static <T extends Measurable> EagerBuffer<T> createEagerBuffer(MemoryTracker memoryTracker) {
        return EagerBuffer.createEagerBuffer(memoryTracker, 1024, 0x7FFFFFF7, GROW_NEW_CHUNKS_BY_50_PCT);
    }

    public static <T extends Measurable> EagerBuffer<T> createEagerBuffer(MemoryTracker memoryTracker, int initialChunkSize) {
        return EagerBuffer.createEagerBuffer(memoryTracker, initialChunkSize, 0x7FFFFFF7, GROW_NEW_CHUNKS_BY_50_PCT);
    }

    public static <T extends Measurable> EagerBuffer<T> createEagerBuffer(MemoryTracker memoryTracker, int initialChunkSize, int maxChunkSize, IntUnaryOperator growthStrategy) {
        return EagerBuffer.createEagerBuffer(memoryTracker, initialChunkSize, maxChunkSize, growthStrategy, ChunkMemoryEstimator.createDefault());
    }

    public static <T extends Measurable> EagerBuffer<T> createEagerBuffer(MemoryTracker memoryTracker, int initialChunkSize, int maxChunkSize, IntUnaryOperator growthStrategy, ChunkMemoryEstimator<T> memoryEstimator) {
        MemoryTracker scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();
        scopedMemoryTracker.allocateHeap(SHALLOW_SIZE + HeapEstimator.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE + HeapEstimator.shallowSizeOfInstance(IntUnaryOperator.class) + HeapEstimator.shallowSizeOfInstance(ChunkMemoryEstimator.class));
        return new EagerBuffer<T>(scopedMemoryTracker, initialChunkSize, maxChunkSize, growthStrategy, memoryEstimator);
    }

    private EagerBuffer(MemoryTracker scopedMemoryTracker, int initialChunkSize, int maxChunkSize, IntUnaryOperator growthStrategy, ChunkMemoryEstimator<T> memoryEstimator) {
        this.scopedMemoryTracker = scopedMemoryTracker;
        this.maxChunkSize = maxChunkSize;
        this.growthStrategy = growthStrategy;
        this.memoryEstimator = memoryEstimator;
        this.first = new Chunk<T>(initialChunkSize, scopedMemoryTracker.getScopedMemoryTracker(), memoryEstimator);
        this.current = this.first;
    }

    public void add(T element) {
        if (!this.current.add(element)) {
            int newChunkSize = this.grow(this.current.elements.length);
            Chunk<T> newChunk = new Chunk<T>(newChunkSize, this.scopedMemoryTracker.getScopedMemoryTracker(), this.memoryEstimator);
            this.current.next = newChunk;
            this.current = newChunk;
            this.current.add(element);
        }
        ++this.size;
    }

    public long size() {
        return this.size;
    }

    public Iterator<T> iterator() {
        return new EagerBufferIterator(false);
    }

    public Iterator<T> autoClosingIterator() {
        return new EagerBufferIterator(true);
    }

    public void closeInternal() {
        this.first = null;
        this.current = null;
        this.scopedMemoryTracker.close();
    }

    public boolean isClosed() {
        return false;
    }

    @VisibleForTesting
    public int numberOfChunks() {
        int i = 0;
        Chunk<T> chunk = this.first;
        while (chunk != null) {
            chunk = chunk.next;
            ++i;
        }
        return i;
    }

    private int grow(int size) {
        if (size == this.maxChunkSize) {
            return size;
        }
        int newSize = this.growthStrategy.applyAsInt(size);
        if (newSize <= 0 || newSize > this.maxChunkSize) {
            return this.maxChunkSize;
        }
        return newSize;
    }

    public static interface ChunkMemoryEstimator<T extends Measurable> {
        public long estimateHeapUsage(T var1, T var2);

        public static <T extends Measurable> ChunkMemoryEstimator<T> createDefault() {
            return (element, previous) -> element.estimatedHeapUsage();
        }
    }

    private static class Chunk<T extends Measurable> {
        private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Chunk.class);
        private final Object[] elements;
        private final ChunkMemoryEstimator<T> memoryEstimator;
        private final MemoryTracker memoryTracker;
        private Chunk<T> next;
        private int cursor;

        Chunk(int size, MemoryTracker memoryTracker, ChunkMemoryEstimator<T> memoryEstimator) {
            memoryTracker.allocateHeap(SHALLOW_SIZE + HeapEstimator.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE + HeapEstimator.shallowSizeOfObjectArray((int)size));
            this.elements = new Object[size];
            this.memoryTracker = memoryTracker;
            this.memoryEstimator = memoryEstimator;
        }

        boolean add(T element) {
            if (this.cursor < this.elements.length) {
                Measurable previous = this.cursor == 0 ? null : (Measurable)this.elements[this.cursor - 1];
                this.memoryTracker.allocateHeap(this.memoryEstimator.estimateHeapUsage((Measurable)element, previous));
                this.elements[this.cursor++] = element;
                return true;
            }
            return false;
        }

        void close() {
            this.memoryTracker.close();
        }
    }

    private class EagerBufferIterator
    implements Iterator<T> {
        private final boolean autoClosing;
        private Chunk<T> chunk;
        private int index;

        EagerBufferIterator(boolean autoClosing) {
            this.autoClosing = autoClosing;
            this.chunk = EagerBuffer.this.first;
            if (autoClosing) {
                EagerBuffer.this.first = null;
                EagerBuffer.this.current = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.chunk == null || this.index >= this.chunk.cursor) {
                if (this.autoClosing) {
                    EagerBuffer.this.close();
                }
                return false;
            }
            return true;
        }

        @Override
        public T next() {
            Object element = this.chunk.elements[this.index++];
            if (this.index >= this.chunk.cursor) {
                Chunk chunkToRelease = this.chunk;
                this.chunk = this.chunk.next;
                this.index = 0;
                if (this.autoClosing) {
                    chunkToRelease.close();
                }
            }
            return (Measurable)element;
        }
    }
}

