/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.EntityRange;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.impl.index.schema.CompositeTokenScanValueIterator;
import org.neo4j.kernel.impl.index.schema.TokenScanValueIterator;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityIdIterator;

public class TokenIndexScanIdIterator
implements EntityIdIterator {
    private final TokenIndexReader tokenIndexReader;
    private final CursorContext cursorContext;
    protected CompositeTokenScanValueIterator idIterator;
    protected long lastReturnedId = -1L;
    private final int[] tokenIds;

    TokenIndexScanIdIterator(TokenIndexReader tokenIndexReader, int[] tokenIds, CursorContext cursorContext) {
        this.tokenIndexReader = tokenIndexReader;
        this.cursorContext = cursorContext;
        this.tokenIds = tokenIds;
        this.idIterator = this.createIdIterator(EntityRange.FULL, tokenIds);
    }

    public long next() {
        long next;
        this.lastReturnedId = next = this.idIterator.next();
        return next;
    }

    public boolean hasNext() {
        return this.idIterator.hasNext();
    }

    public void close() {
        this.idIterator.close();
    }

    @Override
    public void invalidateCache() {
        this.idIterator.close();
        this.idIterator = this.createIdIterator(EntityRange.from((long)(this.lastReturnedId + 1L)), this.tokenIds);
    }

    private CompositeTokenScanValueIterator createIdIterator(EntityRange range, int[] tokenIds) {
        return new CompositeTokenScanValueIterator(Arrays.stream(tokenIds).mapToObj(token -> new QueryResultIterator(range, token)).collect(Collectors.toList()), false);
    }

    private class QueryResultIterator
    implements TokenScanValueIterator {
        private final SimpleProgressorClient client;
        private final int tokenId;

        QueryResultIterator(EntityRange entityRange, int tokenId) {
            this.tokenId = tokenId;
            this.client = new SimpleProgressorClient();
            TokenIndexScanIdIterator.this.tokenIndexReader.query((IndexProgressor.EntityTokenClient)this.client, IndexQueryConstraints.unconstrained(), new TokenPredicate(tokenId), entityRange, TokenIndexScanIdIterator.this.cursorContext);
        }

        public long next() {
            return this.client.next();
        }

        public boolean hasNext() {
            return this.client.hasNext();
        }

        @Override
        public int tokenId() {
            return this.tokenId;
        }

        public void close() {
            this.client.close();
        }
    }

    private static class SimpleProgressorClient
    implements IndexProgressor.EntityTokenClient,
    AutoCloseable {
        private long entityId;
        private IndexProgressor progressor;
        private boolean hasNextDecided;
        private boolean hasNext;

        private SimpleProgressorClient() {
        }

        public void initialize(IndexProgressor progressor, int token, IndexOrder order) {
            this.progressor = progressor;
        }

        public void initialize(IndexProgressor progressor, int token, LongIterator added, LongSet removed, AccessMode accessMode) {
            throw new UnsupportedOperationException();
        }

        public long next() {
            if (!this.hasNextDecided && !this.hasNext()) {
                throw new NoSuchElementException("No more elements in " + this);
            }
            this.hasNextDecided = false;
            return this.entityId;
        }

        public boolean hasNext() {
            if (this.hasNextDecided) {
                return this.hasNext;
            }
            this.hasNext = this.progressor.next();
            this.hasNextDecided = true;
            return this.hasNext;
        }

        public boolean acceptEntity(long reference, int tokenId) {
            this.entityId = reference;
            return true;
        }

        @Override
        public void close() {
            this.progressor.close();
        }
    }
}

