/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import java.util.Optional;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.reverse.CommandBatchCursors;
import org.neo4j.kernel.impl.transaction.log.reverse.DefaultCommandBatchCursors;
import org.neo4j.kernel.impl.transaction.log.reverse.PrefetchedCommandBatchCursors;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedTransactionCursorMonitor;

public class ReversedMultiFileCommandBatchCursor
implements CommandBatchCursor {
    private final CommandBatchCursors commandBatchCursors;
    private CommandBatchCursor currentLogCommandBatchCursor;

    public static CommandBatchCursor fromLogFile(LogFile logFile, LogPosition backToPosition, LogEntryReader logEntryReader, boolean failOnCorruptedLogFiles, ReversedTransactionCursorMonitor monitor, boolean presketch) {
        if (presketch) {
            return new ReversedMultiFileCommandBatchCursor(new PrefetchedCommandBatchCursors(logFile, backToPosition, logEntryReader, failOnCorruptedLogFiles, monitor));
        }
        return new ReversedMultiFileCommandBatchCursor(new DefaultCommandBatchCursors(logFile, backToPosition, logEntryReader, failOnCorruptedLogFiles, monitor));
    }

    public ReversedMultiFileCommandBatchCursor(CommandBatchCursors commandBatchCursors) {
        this.commandBatchCursors = commandBatchCursors;
    }

    public CommittedCommandBatch get() {
        return (CommittedCommandBatch)this.currentLogCommandBatchCursor.get();
    }

    public boolean next() throws IOException {
        while (this.currentLogCommandBatchCursor == null || !this.currentLogCommandBatchCursor.next()) {
            Optional<CommandBatchCursor> cursor = this.commandBatchCursors.next();
            if (cursor.isEmpty()) {
                return false;
            }
            this.closeCurrent();
            this.currentLogCommandBatchCursor = cursor.get();
        }
        return true;
    }

    public void close() throws IOException {
        this.closeCurrent();
        this.commandBatchCursors.close();
    }

    private void closeCurrent() throws IOException {
        if (this.currentLogCommandBatchCursor != null) {
            this.currentLogCommandBatchCursor.close();
            this.currentLogCommandBatchCursor = null;
        }
    }

    @Override
    public LogPosition position() {
        return this.currentLogCommandBatchCursor.position();
    }
}

