/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.procedure;

import java.time.Clock;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.newapi.ProcedureTransactionImpl;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.values.ValueMapper;

public class BasicContext
implements Context {
    private final DependencyResolver resolver;
    private final KernelTransaction kernelTransaction;
    private final SecurityContext securityContext;
    private final ClockContext clockContext;
    private final ValueMapper<Object> valueMapper;
    private final Thread thread;
    private final ProcedureCallContext procedureCallContext;
    private final Supplier<GraphDatabaseAPI> graphDatabaseAPISupplier;

    private BasicContext(DependencyResolver resolver, KernelTransaction kernelTransaction, SecurityContext securityContext, ClockContext clockContext, ValueMapper<Object> valueMapper, Thread thread, ProcedureCallContext procedureCallContext, Supplier<GraphDatabaseAPI> graphDatabaseAPISupplier) {
        this.resolver = resolver;
        this.kernelTransaction = kernelTransaction;
        this.securityContext = securityContext;
        this.clockContext = clockContext;
        this.valueMapper = valueMapper;
        this.thread = thread;
        this.procedureCallContext = procedureCallContext;
        this.graphDatabaseAPISupplier = graphDatabaseAPISupplier;
    }

    @Override
    public ValueMapper<Object> valueMapper() {
        return this.valueMapper;
    }

    @Override
    public SecurityContext securityContext() {
        return this.securityContext;
    }

    @Override
    public DependencyResolver dependencyResolver() {
        return this.resolver;
    }

    @Override
    public GraphDatabaseAPI graphDatabaseAPI() {
        return this.graphDatabaseAPISupplier.get();
    }

    @Override
    public Thread thread() {
        return this.thread;
    }

    @Override
    public Transaction transaction() throws ProcedureException {
        return new ProcedureTransactionImpl(this.internalTransaction());
    }

    @Override
    public InternalTransaction internalTransaction() throws ProcedureException {
        return BasicContext.throwIfNull("Transaction", this.kernelTransaction, KernelTransaction::internalTransaction);
    }

    @Override
    public InternalTransaction internalTransactionOrNull() {
        return this.kernelTransaction == null ? null : this.kernelTransaction.internalTransaction();
    }

    @Override
    public KernelTransaction kernelTransaction() throws ProcedureException {
        return (KernelTransaction)BasicContext.throwIfNull("KernelTransaction", this.kernelTransaction);
    }

    @Override
    public Clock systemClock() throws ProcedureException {
        return BasicContext.throwIfNull("SystemClock", this.clockContext, ClockContext::systemClock);
    }

    @Override
    public Clock statementClock() throws ProcedureException {
        return BasicContext.throwIfNull("StatementClock", this.clockContext, ClockContext::statementClock);
    }

    @Override
    public Clock transactionClock() throws ProcedureException {
        return BasicContext.throwIfNull("TransactionClock", this.clockContext, ClockContext::transactionClock);
    }

    @Override
    public ProcedureCallContext procedureCallContext() {
        return this.procedureCallContext;
    }

    public static ContextBuilder buildContext(DependencyResolver dependencyResolver, ValueMapper<Object> valueMapper) {
        return new ContextBuilder(dependencyResolver, valueMapper);
    }

    private static <T, U> T throwIfNull(String name, U value) throws ProcedureException {
        return (T)BasicContext.throwIfNull(name, value, v -> v);
    }

    private static <T, U> T throwIfNull(String name, U value, Function<U, T> producer) throws ProcedureException {
        if (value == null) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "There is no `%s` in the current procedure call context.", new Object[]{name});
        }
        return producer.apply(value);
    }

    public static class ContextBuilder {
        private final DependencyResolver resolver;
        private final Thread thread = Thread.currentThread();
        private final ValueMapper<Object> valueMapper;
        private KernelTransaction procedureTransaction;
        private SecurityContext securityContext = SecurityContext.AUTH_DISABLED;
        private ClockContext clockContext;
        private ProcedureCallContext procedureCallContext;
        private Supplier<GraphDatabaseAPI> graphDatabaseAPISupplier;

        private ContextBuilder(DependencyResolver resolver, ValueMapper<Object> valueMapper) {
            this.resolver = resolver;
            this.valueMapper = valueMapper;
        }

        public ContextBuilder withKernelTransaction(KernelTransaction procedureTransaction) {
            this.procedureTransaction = procedureTransaction;
            return this;
        }

        public ContextBuilder withGraphDatabaseSupplier(Supplier<GraphDatabaseAPI> graphDatabaseAPISupplier) {
            this.graphDatabaseAPISupplier = graphDatabaseAPISupplier;
            return this;
        }

        public ContextBuilder withSecurityContext(SecurityContext securityContext) {
            this.securityContext = securityContext;
            return this;
        }

        public ContextBuilder withClock(ClockContext clockContext) {
            this.clockContext = clockContext;
            return this;
        }

        public ContextBuilder withProcedureCallContext(ProcedureCallContext procedureContext) {
            this.procedureCallContext = procedureContext;
            return this;
        }

        public Context context() {
            Objects.requireNonNull(this.resolver);
            Objects.requireNonNull(this.securityContext);
            Objects.requireNonNull(this.valueMapper);
            Objects.requireNonNull(this.thread);
            return new BasicContext(this.resolver, this.procedureTransaction, this.securityContext, this.clockContext, this.valueMapper, this.thread, this.procedureCallContext, this.graphDatabaseAPISupplier);
        }
    }
}

