/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.database.enrichment;

import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.neo4j.kernel.api.database.enrichment.ValuesReader;
import org.neo4j.storageengine.api.enrichment.WriteEnrichmentChannel;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.utils.TemporalUtil;

public record ValuesWriter(WriteEnrichmentChannel channel) implements ValueWriter<RuntimeException>
{
    public int write(Value value) {
        int position = this.channel.size();
        if (value == null) {
            this.channel.put(ValuesReader.NO_VALUE.id());
        } else {
            this.channel.put(ValuesReader.forValueClass(value.getClass()).id());
            value.writeTo((ValueWriter)this);
        }
        return position;
    }

    public void writeNull() {
    }

    public void writeBoolean(boolean value) {
        this.channel.put((byte)(value ? 1 : 0));
    }

    public void writeInteger(byte value) {
        this.channel.put(value);
    }

    public void writeInteger(short value) {
        this.channel.putShort(value);
    }

    public void writeInteger(int value) {
        this.channel.putInt(value);
    }

    public void writeInteger(long value) {
        this.channel.putLong(value);
    }

    public void writeFloatingPoint(float value) {
        this.channel.putFloat(value);
    }

    public void writeFloatingPoint(double value) {
        this.channel.putDouble(value);
    }

    public void writeString(String value) {
        if (value == null) {
            this.channel.putInt(-1);
        } else {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            this.channel.putInt(bytes.length).put(bytes);
        }
    }

    public void writeString(char value) {
        this.channel.putChar(value);
    }

    public void beginArray(int size, ValueWriter.ArrayType arrayType) {
        this.channel.putInt(size);
    }

    public void endArray() {
    }

    public void writeByteArray(byte[] value) {
        this.channel.putInt(value.length);
        this.channel.put(value);
    }

    public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) {
        Preconditions.checkArgument((coordinate.length == crs.getDimension() ? 1 : 0) != 0, (String)"Dimension for %s is %d, got %d", (Object[])new Object[]{crs.getName(), crs.getDimension(), coordinate.length});
        this.channel.putInt(crs.getCode());
        for (int i = 0; i < crs.getDimension(); ++i) {
            this.channel.putDouble(coordinate[i]);
        }
    }

    public void writeDuration(long months, long days, long seconds, int nanos) {
        this.channel.putLong(months);
        this.channel.putLong(days);
        this.channel.putLong(seconds);
        this.channel.putInt(nanos);
    }

    public void writeDate(LocalDate localDate) {
        this.channel.putLong(localDate.toEpochDay());
    }

    public void writeLocalTime(LocalTime localTime) {
        this.channel.putLong(localTime.toNanoOfDay());
    }

    public void writeTime(OffsetTime offsetTime) {
        this.channel.putLong(TemporalUtil.getNanosOfDayUTC((OffsetTime)offsetTime));
        this.channel.putInt(offsetTime.getOffset().getTotalSeconds());
    }

    public void writeLocalDateTime(LocalDateTime localDateTime) {
        this.channel.putLong(localDateTime.toEpochSecond(ZoneOffset.UTC));
        this.channel.putInt(localDateTime.getNano());
    }

    public void writeDateTime(ZonedDateTime zonedDateTime) {
        this.channel.putLong(zonedDateTime.toEpochSecond());
        this.channel.putInt(zonedDateTime.getNano());
        ZoneId zone = zonedDateTime.getZone();
        if (zone instanceof ZoneOffset) {
            ZoneOffset zoneOffset = (ZoneOffset)zone;
            int offsetSeconds = zoneOffset.getTotalSeconds();
            this.channel.putInt(offsetSeconds << 1);
        } else {
            int zoneId = TimeZones.map((String)zone.getId()) << 1 | 1;
            this.channel.putInt(zoneId);
        }
    }
}

