/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Arrays;
import java.util.Optional;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.util.Preconditions;

public abstract class AbstractSystemGraphComponent
implements SystemGraphComponent {
    protected final Config config;

    public AbstractSystemGraphComponent(Config config) {
        this.config = config;
    }

    protected void initializeSystemGraphConstraints(Transaction tx) {
    }

    protected void initializeSystemGraphModel(Transaction tx, GraphDatabaseService systemDb) throws Exception {
    }

    protected void verifySystemGraph(GraphDatabaseService system) throws Exception {
    }

    private void initializeSystemGraphConstraints(GraphDatabaseService system) {
        try (Transaction tx = system.beginTx();){
            this.initializeSystemGraphConstraints(tx);
            tx.commit();
        }
    }

    protected void initializeSystemGraphModel(GraphDatabaseService system) throws Exception {
        try (Transaction tx = system.beginTx();){
            this.initializeSystemGraphModel(tx, system);
            tx.commit();
        }
    }

    protected void postInitialization(GraphDatabaseService system, boolean wasInitialized) throws Exception {
    }

    @Override
    public void initializeSystemGraph(GraphDatabaseService system, boolean firstInitialization) throws Exception {
        boolean mayUpgrade = (Boolean)this.config.get(GraphDatabaseInternalSettings.automatic_upgrade_enabled);
        Preconditions.checkState((boolean)system.databaseName().equals("system"), (String)("Cannot initialize system graph on database '" + system.databaseName() + "'"));
        SystemGraphComponent.Status status = this.detect(system);
        if (status == SystemGraphComponent.Status.UNINITIALIZED) {
            this.initializeSystemGraphConstraints(system);
            this.initializeSystemGraphModel(system);
            this.postInitialization(system, true);
        } else if (status == SystemGraphComponent.Status.CURRENT || status == SystemGraphComponent.Status.REQUIRES_UPGRADE && !mayUpgrade) {
            this.verifySystemGraph(system);
            this.postInitialization(system, false);
        } else if (mayUpgrade && status == SystemGraphComponent.Status.REQUIRES_UPGRADE || status == SystemGraphComponent.Status.UNSUPPORTED_BUT_CAN_UPGRADE) {
            this.upgradeToCurrent(system);
        } else {
            throw new IllegalStateException(String.format("Unsupported component state for '%s': %s", this.componentName(), status.description()));
        }
    }

    protected static void initializeSystemGraphConstraint(Transaction tx, Label label, String ... properties) {
        if (!AbstractSystemGraphComponent.hasUniqueConstraint(tx, label, properties)) {
            AbstractSystemGraphComponent.checkForClashingIndexes(tx, label, properties);
            ConstraintCreator cb = tx.schema().constraintFor(label);
            for (String prop : properties) {
                cb = cb.assertPropertyIsUnique(prop);
            }
            cb.create();
        }
    }

    protected static boolean hasUniqueConstraint(Transaction tx, Label label, String ... properties) {
        return AbstractSystemGraphComponent.findUniqueConstraint(tx, label, properties).isPresent();
    }

    protected static Optional<ConstraintDefinition> findUniqueConstraint(Transaction tx, Label label, String ... properties) {
        for (ConstraintDefinition constraintDefinition : tx.schema().getConstraints(label)) {
            if (!constraintDefinition.getPropertyKeys().equals(Arrays.asList(properties)) || !constraintDefinition.isConstraintType(ConstraintType.UNIQUENESS)) continue;
            return Optional.of(constraintDefinition);
        }
        return Optional.empty();
    }

    private static void checkForClashingIndexes(Transaction tx, Label label, String ... properties) {
        tx.schema().getIndexes(label).forEach(index -> {
            Object[] propertyKeys = (String[])Iterables.asArray(String.class, (Iterable)index.getPropertyKeys());
            if (Arrays.equals(propertyKeys, properties)) {
                index.drop();
            }
        });
    }
}

