/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring;

import java.util.Objects;
import org.neo4j.logging.Log;
import org.neo4j.monitoring.VmPauseMonitor;

public class LoggingVmPauseMonitor
implements VmPauseMonitor.Monitor {
    private final Log log;

    public LoggingVmPauseMonitor(Log log) {
        this.log = Objects.requireNonNull(log);
    }

    public void started() {
        this.log.debug("Starting VM pause monitor");
    }

    public void stopped() {
        this.log.debug("Stopping VM pause monitor");
    }

    public void interrupted() {
        this.log.debug("VM pause monitor stopped");
    }

    public void failed(Exception e) {
        this.log.debug("VM pause monitor failed", (Throwable)e);
    }

    public void pauseDetected(VmPauseMonitor.VmPauseInfo info) {
        this.log.warn("Detected VM stop-the-world pause: %s", new Object[]{info});
    }
}

