/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.Paths;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.util.NodeEntityWrappingNodeValue;
import org.neo4j.kernel.impl.util.PathWrappingPathValue;
import org.neo4j.kernel.impl.util.RelationshipEntityWrappingValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public class DefaultValueMapper
extends ValueMapper.JavaMapper {
    private final InternalTransaction transaction;

    public DefaultValueMapper(InternalTransaction transaction) {
        this.transaction = transaction;
    }

    public Node mapNode(VirtualNodeValue value) {
        if (value instanceof NodeEntityWrappingNodeValue) {
            return ((NodeEntityWrappingNodeValue)value).getEntity();
        }
        return this.mapNode(value.id());
    }

    public Relationship mapRelationship(VirtualRelationshipValue value) {
        if (value instanceof RelationshipEntityWrappingValue) {
            return ((RelationshipEntityWrappingValue)value).getEntity();
        }
        return this.mapRelationship(value.id());
    }

    public Path mapPath(VirtualPathValue value) {
        if (value instanceof PathWrappingPathValue) {
            return ((PathWrappingPathValue)value).path();
        }
        return new CoreAPIPath(value);
    }

    private static <U, V> Iterable<V> asList(final long[] values, final LongToObjectFunction<V> mapper) {
        return () -> new Iterator<V>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < values.length;
            }

            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return mapper.apply(values[this.index++]);
            }
        };
    }

    private Node mapNode(long value) {
        return new NodeEntity(this.transaction, value);
    }

    private Relationship mapRelationship(long value) {
        return new RelationshipEntity(this.transaction, value);
    }

    private static <U, V> Iterable<V> asReverseList(final long[] values, final LongToObjectFunction<V> mapper) {
        return () -> new Iterator<V>(){
            private int index;
            {
                this.index = values.length - 1;
            }

            @Override
            public boolean hasNext() {
                return this.index >= 0;
            }

            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return mapper.apply(values[this.index--]);
            }
        };
    }

    class CoreAPIPath
    implements Path {
        private final VirtualPathValue value;

        CoreAPIPath(VirtualPathValue value) {
            this.value = value;
        }

        public VirtualPathValue pathValue() {
            return this.value;
        }

        public String toString() {
            return Paths.defaultPathToStringWithNotInTransactionFallback((Path)this);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CoreAPIPath) {
                return this.value.equals((VirtualValue)((CoreAPIPath)obj).value);
            }
            if (obj instanceof Path) {
                Path other = (Path)obj;
                if (this.value.nodeIds()[0] != other.startNode().getId()) {
                    return false;
                }
                return Iterators.iteratorsEqual(this.relationships().iterator(), other.relationships().iterator());
            }
            return false;
        }

        public Node startNode() {
            return DefaultValueMapper.this.mapNode(this.value.nodeIds()[0]);
        }

        public Node endNode() {
            long[] longs = this.value.nodeIds();
            return DefaultValueMapper.this.mapNode(longs[longs.length - 1]);
        }

        public Relationship lastRelationship() {
            if (this.value.size() == 0) {
                return null;
            }
            long[] relationshipIds = this.value.relationshipIds();
            return DefaultValueMapper.this.mapRelationship(relationshipIds[relationshipIds.length - 1]);
        }

        public Iterable<Relationship> relationships() {
            return DefaultValueMapper.asList(this.value.relationshipIds(), (LongToObjectFunction & Serializable)x$0 -> DefaultValueMapper.this.mapRelationship(x$0));
        }

        public Iterable<Relationship> reverseRelationships() {
            return DefaultValueMapper.asReverseList(this.value.relationshipIds(), (LongToObjectFunction & Serializable)x$0 -> DefaultValueMapper.this.mapRelationship(x$0));
        }

        public Iterable<Node> nodes() {
            return DefaultValueMapper.asList(this.value.nodeIds(), (LongToObjectFunction & Serializable)x$0 -> DefaultValueMapper.this.mapNode(x$0));
        }

        public Iterable<Node> reverseNodes() {
            return DefaultValueMapper.asReverseList(this.value.nodeIds(), (LongToObjectFunction & Serializable)x$0 -> DefaultValueMapper.this.mapNode(x$0));
        }

        public int length() {
            return this.value.size();
        }

        public Iterator<Entity> iterator() {
            return new Iterator<Entity>(){
                private final int size;
                private int index;
                private final long[] nodes;
                private final long[] relationships;
                {
                    this.size = 2 * CoreAPIPath.this.value.size() + 1;
                    this.nodes = CoreAPIPath.this.value.nodeIds();
                    this.relationships = CoreAPIPath.this.value.relationshipIds();
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.size;
                }

                @Override
                public Entity next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object entity = (this.index & 1) == 0 ? DefaultValueMapper.this.mapNode(this.nodes[this.index >> 1]) : DefaultValueMapper.this.mapRelationship(this.relationships[this.index >> 1]);
                    ++this.index;
                    return entity;
                }
            };
        }
    }
}

