/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.IncompleteLogHeaderException;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;

public class ReaderLogVersionBridge
implements LogVersionBridge {
    private final LogFile logFile;

    public ReaderLogVersionBridge(LogFile logFile) {
        this.logFile = logFile;
    }

    @Override
    public LogVersionedStoreChannel next(LogVersionedStoreChannel channel, boolean raw) throws IOException {
        PhysicalLogVersionedStoreChannel nextChannel;
        try {
            nextChannel = this.logFile.openForVersion(channel.getVersion() + 1L, raw);
        }
        catch (NoSuchFileException | IncompleteLogHeaderException e) {
            return channel;
        }
        channel.close();
        return nextChannel;
    }
}

