/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.util.Objects;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.storageengine.api.StorageCommand;

public class CommittedTransactionRepresentation {
    private final LogEntryStart startEntry;
    private final TransactionRepresentation transactionRepresentation;
    private final LogEntryCommit commitEntry;

    public CommittedTransactionRepresentation(LogEntryStart startEntry, TransactionRepresentation transactionRepresentation, LogEntryCommit commitEntry) {
        this.startEntry = startEntry;
        this.transactionRepresentation = transactionRepresentation;
        this.commitEntry = commitEntry;
    }

    public void accept(Visitor<StorageCommand, IOException> visitor) throws IOException {
        this.transactionRepresentation.accept(visitor);
    }

    public LogEntryStart getStartEntry() {
        return this.startEntry;
    }

    public TransactionRepresentation getTransactionRepresentation() {
        return this.transactionRepresentation;
    }

    public LogEntryCommit getCommitEntry() {
        return this.commitEntry;
    }

    public int getChecksum() {
        return this.getCommitEntry().getChecksum();
    }

    public String toString() {
        return "CommittedTransactionRepresentation{startEntry=" + String.valueOf(this.startEntry) + ", transactionRepresentation=" + String.valueOf(this.transactionRepresentation) + ", commitEntry=" + String.valueOf(this.commitEntry) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommittedTransactionRepresentation that = (CommittedTransactionRepresentation)o;
        return Objects.equals(this.startEntry, that.startEntry) && Objects.equals(this.transactionRepresentation, that.transactionRepresentation) && Objects.equals(this.commitEntry, that.commitEntry);
    }

    public int hashCode() {
        return Objects.hash(this.startEntry, this.transactionRepresentation, this.commitEntry);
    }
}

