/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Properties;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexSettingsKeys;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

class FulltextConfigExtractor {
    private static final String INDEX_CONFIG_FILE = "fulltext-index.properties";
    private static final String INDEX_CONFIG_ANALYZER = "analyzer";
    private static final String INDEX_CONFIG_EVENTUALLY_CONSISTENT = "eventually_consistent";

    FulltextConfigExtractor() {
    }

    static IndexConfig indexConfigFromFulltextDirectory(FileSystemAbstraction fs, Path fulltextIndexDirectory) {
        Path settingsFile = fulltextIndexDirectory.resolve(INDEX_CONFIG_FILE);
        Properties settings = new Properties();
        if (fs.fileExists(settingsFile)) {
            try (Reader reader = fs.openAsReader(settingsFile, StandardCharsets.UTF_8);){
                settings.load(reader);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read persisted fulltext index properties: " + String.valueOf(settingsFile), e);
            }
        }
        HashMap<String, Object> indexConfig = new HashMap<String, Object>();
        TextValue analyser = FulltextConfigExtractor.extractSetting(settings, INDEX_CONFIG_ANALYZER);
        BooleanValue eventuallyConsistent = FulltextConfigExtractor.extractBooleanSetting(settings, INDEX_CONFIG_EVENTUALLY_CONSISTENT);
        if (analyser != null) {
            indexConfig.put(FulltextIndexSettingsKeys.ANALYZER, analyser);
        }
        if (eventuallyConsistent != null) {
            indexConfig.put(FulltextIndexSettingsKeys.EVENTUALLY_CONSISTENT, eventuallyConsistent);
        }
        return IndexConfig.with(indexConfig);
    }

    private static TextValue extractSetting(Properties settings, String setting) {
        String property = settings.getProperty(setting);
        if (property != null) {
            return Values.stringValue((String)property);
        }
        return null;
    }

    private static BooleanValue extractBooleanSetting(Properties settings, String setting) {
        String property = settings.getProperty(setting);
        if (property != null) {
            return Values.booleanValue((boolean)Boolean.parseBoolean(property));
        }
        return null;
    }
}

