/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.EnumSet;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrderCapability;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.NativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.RangeBlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.RangeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.RangeKey;
import org.neo4j.kernel.impl.index.schema.RangeLayout;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueGroup;

public class RangeIndexProvider
extends NativeIndexProvider<RangeKey, RangeLayout> {
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor("range", "1.0");
    public static final RangeIndexCapability CAPABILITY = new RangeIndexCapability();
    private final boolean archiveFailedIndex;
    private final Config config;

    public RangeIndexProvider(DatabaseIndexContext databaseIndexContext, IndexDirectoryStructure.Factory directoryStructureFactory, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Config config) {
        super(databaseIndexContext, DESCRIPTOR, directoryStructureFactory, recoveryCleanupWorkCollector);
        this.archiveFailedIndex = (Boolean)config.get(GraphDatabaseInternalSettings.archive_failed_index);
        this.config = config;
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index) {
        return index.getCapability().equals(IndexCapability.NO_CAPABILITY) ? index.withIndexCapability((IndexCapability)CAPABILITY) : index;
    }

    @Override
    RangeLayout layout(IndexDescriptor descriptor, Path storeFile) {
        int numberOfSlots = descriptor.schema().getPropertyIds().length;
        return new RangeLayout(numberOfSlots);
    }

    @Override
    protected IndexPopulator newIndexPopulator(IndexFiles indexFiles, RangeLayout layout, IndexDescriptor descriptor, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup) {
        return new RangeBlockBasedIndexPopulator(this.databaseIndexContext, indexFiles, layout, descriptor, this.archiveFailedIndex, bufferFactory, this.config, memoryTracker, tokenNameLookup);
    }

    @Override
    protected IndexAccessor newIndexAccessor(IndexFiles indexFiles, RangeLayout layout, IndexDescriptor descriptor, TokenNameLookup tokenNameLookup) {
        return new RangeIndexAccessor(this.databaseIndexContext, indexFiles, layout, this.recoveryCleanupWorkCollector, descriptor, tokenNameLookup);
    }

    public void validatePrototype(IndexPrototype prototype) {
        IndexType indexType = prototype.getIndexType();
        if (indexType != IndexType.RANGE) {
            String providerName = this.getProviderDescriptor().name();
            throw new IllegalArgumentException("The '" + providerName + "' index provider does not support " + String.valueOf(indexType) + " indexes: " + String.valueOf(prototype));
        }
        if (!prototype.schema().isLabelSchemaDescriptor() && !prototype.schema().isRelationshipTypeSchemaDescriptor()) {
            throw new IllegalArgumentException("The " + String.valueOf(prototype.schema()) + " index schema is not a range index schema, which it is required to be for the '" + this.getProviderDescriptor().name() + "' index provider to be able to create an index.");
        }
    }

    public IndexType getIndexType() {
        return IndexType.RANGE;
    }

    private static class RangeIndexCapability
    implements IndexCapability {
        private RangeIndexCapability() {
        }

        public IndexOrderCapability orderCapability(ValueCategory ... valueCategories) {
            return IndexOrderCapability.BOTH_FULLY_SORTED;
        }

        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            return IndexValueCapability.YES;
        }

        public boolean areValueCategoriesAccepted(ValueCategory ... valueCategories) {
            Preconditions.requireNonEmpty((Object[])valueCategories);
            Preconditions.requireNoNullElements((Object[])valueCategories);
            return true;
        }

        public boolean areValuesAccepted(Value ... values) {
            Preconditions.requireNonEmpty((Object[])values);
            Preconditions.requireNoNullElements((Object[])values);
            return true;
        }

        public boolean isQuerySupported(IndexQuery.IndexQueryType queryType, ValueCategory valueCategory) {
            if (!this.areValueCategoriesAccepted(valueCategory)) {
                return false;
            }
            switch (queryType) {
                case ALL_ENTRIES: 
                case EXISTS: 
                case EXACT: 
                case STRING_PREFIX: {
                    return true;
                }
                case RANGE: {
                    return valueCategory != ValueCategory.UNKNOWN && valueCategory != ValueCategory.GEOMETRY;
                }
            }
            return false;
        }

        public double getCostMultiplier(IndexQuery.IndexQueryType ... queryTypes) {
            return 1.0;
        }

        public boolean supportPartitionedScan(IndexQuery ... queries) {
            block4: {
                block3: {
                    Preconditions.requireNonEmpty((Object[])queries);
                    Preconditions.requireNoNullElements((Object[])queries);
                    if (Arrays.stream(queries).anyMatch(query -> EnumSet.of(IndexQuery.IndexQueryType.TOKEN_LOOKUP, IndexQuery.IndexQueryType.STRING_SUFFIX, IndexQuery.IndexQueryType.STRING_CONTAINS).contains(query.type()) || query.type() == IndexQuery.IndexQueryType.RANGE && EnumSet.of(ValueGroup.GEOMETRY, ValueGroup.GEOMETRY_ARRAY).contains(((PropertyIndexQuery)query).valueGroup()))) break block3;
                    if (queries.length <= 1) break block4;
                    if (!Arrays.stream(queries).map(IndexQuery::type).anyMatch(arg_0 -> IndexQuery.IndexQueryType.ALL_ENTRIES.equals(arg_0))) break block4;
                }
                return false;
            }
            for (int i = 1; i < queries.length; ++i) {
                IndexQuery.IndexQueryType prev = queries[i - 1].type();
                IndexQuery.IndexQueryType curr = queries[i].type();
                if (prev == IndexQuery.IndexQueryType.EXACT || !EnumSet.of(IndexQuery.IndexQueryType.EXISTS, IndexQuery.IndexQueryType.RANGE, IndexQuery.IndexQueryType.STRING_PREFIX).contains(prev) || curr == IndexQuery.IndexQueryType.EXISTS) continue;
                return false;
            }
            return true;
        }
    }
}

