/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexValueValidator;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.BtreeKey;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericIndexKeyValidator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexReader;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NullValue;
import org.neo4j.kernel.impl.index.schema.SpatialConfigVisitor;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.values.storable.Value;

class GenericNativeIndexAccessor
extends NativeIndexAccessor<BtreeKey> {
    private final IndexSpecificSpaceFillingCurveSettings spaceFillingCurveSettings;
    private final SpaceFillingCurveConfiguration configuration;
    private final TokenNameLookup tokenNameLookup;
    private IndexValueValidator validator;

    GenericNativeIndexAccessor(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexLayout<BtreeKey> layout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexDescriptor descriptor, IndexSpecificSpaceFillingCurveSettings spaceFillingCurveSettings, SpaceFillingCurveConfiguration configuration, TokenNameLookup tokenNameLookup) {
        super(databaseIndexContext, indexFiles, layout, descriptor);
        this.spaceFillingCurveSettings = spaceFillingCurveSettings;
        this.configuration = configuration;
        this.tokenNameLookup = tokenNameLookup;
        this.instantiateTree(recoveryCleanupWorkCollector, this.headerWriter);
    }

    @Override
    protected void afterTreeInstantiation(GBPTree<BtreeKey, NullValue> tree) {
        this.validator = new GenericIndexKeyValidator(tree.keyValueSizeCap(), this.descriptor, (Layout<? extends GenericKey<?>, NullValue>)this.layout, this.tokenNameLookup);
    }

    @Override
    public ValueIndexReader newValueReader() {
        this.assertOpen();
        return new GenericNativeIndexReader((GBPTree<BtreeKey, NullValue>)this.tree, this.layout, this.descriptor, this.spaceFillingCurveSettings, this.configuration);
    }

    public void validateBeforeCommit(long entityId, Value[] tuple) {
        this.validator.validate(entityId, tuple);
    }

    public Map<String, Value> indexConfig() {
        HashMap<String, Value> map = new HashMap<String, Value>();
        this.spaceFillingCurveSettings.visitIndexSpecificSettings(new SpatialConfigVisitor(map));
        return map;
    }
}

