/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.stats;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsKey;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsValue;

public class IndexStatisticsLayout
extends Layout.Adapter<IndexStatisticsKey, IndexStatisticsValue> {
    public IndexStatisticsLayout() {
        super(true, 556677L, 0, 2);
    }

    public IndexStatisticsKey newKey() {
        return new IndexStatisticsKey();
    }

    public IndexStatisticsKey copyKey(IndexStatisticsKey key, IndexStatisticsKey into) {
        into.setIndexId(key.getIndexId());
        return into;
    }

    public IndexStatisticsValue newValue() {
        return new IndexStatisticsValue();
    }

    public int keySize(IndexStatisticsKey key) {
        return 64;
    }

    public int valueSize(IndexStatisticsValue value) {
        return 256;
    }

    public void writeKey(PageCursor cursor, IndexStatisticsKey key) {
        cursor.putLong(key.getIndexId());
    }

    public void writeValue(PageCursor cursor, IndexStatisticsValue value) {
        cursor.putLong(value.getSampleUniqueValues());
        cursor.putLong(value.getSampleSize());
        cursor.putLong(value.getUpdatesCount());
        cursor.putLong(value.getIndexSize());
    }

    public void readKey(PageCursor cursor, IndexStatisticsKey into, int keySize) {
        into.setIndexId(cursor.getLong());
    }

    public void readValue(PageCursor cursor, IndexStatisticsValue into, int valueSize) {
        into.setSampleUniqueValues(cursor.getLong());
        into.setSampleSize(cursor.getLong());
        into.setUpdatesCount(cursor.getLong());
        into.setIndexSize(cursor.getLong());
    }

    public int compare(IndexStatisticsKey o1, IndexStatisticsKey o2) {
        return Long.compare(o1.getIndexId(), o2.getIndexId());
    }

    public void initializeAsLowest(IndexStatisticsKey key) {
        key.setIndexId(Long.MIN_VALUE);
    }

    public void initializeAsHighest(IndexStatisticsKey key) {
        key.setIndexId(Long.MAX_VALUE);
    }
}

