/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.dbms.api.DatabaseManagementException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphDbmsModel;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;

public class SystemGraphDatabaseIdRepository
implements DatabaseIdRepository {
    private final Supplier<DatabaseContext> systemDatabaseSupplier;

    public SystemGraphDatabaseIdRepository(Supplier<DatabaseContext> systemDatabaseSupplier) {
        this.systemDatabaseSupplier = systemDatabaseSupplier;
    }

    public Optional<NamedDatabaseId> getByName(NormalizedDatabaseName normalizedDatabaseName) {
        return this.execute(model -> model.getDatabaseIdByAlias(normalizedDatabaseName.name()));
    }

    public Optional<NamedDatabaseId> getById(DatabaseId databaseId) {
        return this.execute(model -> model.getDatabaseIdByUUID(databaseId.uuid()));
    }

    private <T> T execute(Function<TopologyGraphDbmsModel, T> operation) {
        DatabaseContext databaseContext = this.systemDatabaseSupplier.get();
        GraphDatabaseFacade systemDb = databaseContext.databaseFacade();
        if (!systemDb.isAvailable(100L)) {
            throw new DatabaseShutdownException((Throwable)new DatabaseManagementException("System database is not (yet) available"));
        }
        try (Transaction tx = systemDb.beginTx();){
            CommunityTopologyGraphDbmsModel model = new CommunityTopologyGraphDbmsModel(tx);
            T t = operation.apply(model);
            return t;
        }
    }
}

