/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import org.neo4j.configuration.helpers.RemoteUri;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public abstract class DatabaseReference
implements Comparable<DatabaseReference> {
    private static final Comparator<DatabaseReference> referenceComparator = Comparator.comparing(a -> a.alias().name(), String::compareToIgnoreCase);
    private static final Comparator<DatabaseReference> nullSafeReferenceComparator = Comparator.nullsLast(referenceComparator);

    public abstract NormalizedDatabaseName alias();

    public abstract boolean isPrimary();

    public abstract boolean isRemote();

    public abstract UUID id();

    @Override
    public int compareTo(DatabaseReference that) {
        return nullSafeReferenceComparator.compare(this, that);
    }

    public static final class Internal
    extends DatabaseReference {
        private final NormalizedDatabaseName name;
        private final NamedDatabaseId namedDatabaseId;

        public Internal(NormalizedDatabaseName name, NamedDatabaseId namedDatabaseId) {
            this.name = name;
            this.namedDatabaseId = namedDatabaseId;
        }

        public NamedDatabaseId databaseId() {
            return this.namedDatabaseId;
        }

        @Override
        public NormalizedDatabaseName alias() {
            return this.name;
        }

        @Override
        public boolean isPrimary() {
            return Objects.equals(this.name.name(), this.namedDatabaseId.name());
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        @Override
        public UUID id() {
            return this.namedDatabaseId.databaseId().uuid();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Internal internal = (Internal)o;
            return Objects.equals(this.name, internal.name) && Objects.equals(this.namedDatabaseId, internal.namedDatabaseId);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.namedDatabaseId);
        }

        public String toString() {
            return "DatabaseReference.Internal{name=" + String.valueOf(this.name) + ", namedDatabaseId=" + String.valueOf(this.namedDatabaseId) + "}";
        }
    }

    public static final class External
    extends DatabaseReference {
        private final NormalizedDatabaseName targetName;
        private final NormalizedDatabaseName name;
        private final RemoteUri remoteUri;
        private final UUID uuid;

        public External(NormalizedDatabaseName targetName, NormalizedDatabaseName name, RemoteUri remoteUri, UUID uuid) {
            this.targetName = targetName;
            this.name = name;
            this.remoteUri = remoteUri;
            this.uuid = uuid;
        }

        @Override
        public NormalizedDatabaseName alias() {
            return this.name;
        }

        @Override
        public boolean isPrimary() {
            return false;
        }

        @Override
        public boolean isRemote() {
            return true;
        }

        public RemoteUri remoteUri() {
            return this.remoteUri;
        }

        public NormalizedDatabaseName remoteName() {
            return this.targetName;
        }

        @Override
        public UUID id() {
            return this.uuid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            External remote = (External)o;
            return Objects.equals(this.targetName, remote.targetName) && Objects.equals(this.name, remote.name) && Objects.equals(this.remoteUri, remote.remoteUri) && Objects.equals(this.uuid, remote.uuid);
        }

        public int hashCode() {
            return Objects.hash(this.targetName, this.name, this.remoteUri, this.uuid);
        }

        public String toString() {
            return "DatabaseReference.External{remoteName=" + String.valueOf(this.targetName) + ", name=" + String.valueOf(this.name) + ", remoteUri=" + String.valueOf(this.remoteUri) + ", uuid=" + String.valueOf(this.uuid) + "}";
        }
    }
}

