/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.identity;

import java.io.IOException;
import java.util.UUID;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.marshal.SafeStateMarshal;
import org.neo4j.util.Id;

public final class ServerId
extends Id {
    public ServerId(UUID uuid) {
        super(uuid);
    }

    public String toString() {
        return "ServerId{" + this.shortName() + "}";
    }

    public static class Marshal
    extends SafeStateMarshal<ServerId> {
        public static final Marshal INSTANCE = new Marshal();

        private Marshal() {
        }

        public void marshal(ServerId serverId, WritableChannel channel) throws IOException {
            if (serverId == null) {
                channel.put((byte)0);
            } else {
                channel.put((byte)1);
                channel.putLong(serverId.uuid().getMostSignificantBits());
                channel.putLong(serverId.uuid().getLeastSignificantBits());
            }
        }

        public ServerId unmarshal0(ReadableChannel channel) throws IOException {
            byte nullMarker = channel.get();
            if (nullMarker == 0) {
                return null;
            }
            long mostSigBits = channel.getLong();
            long leastSigBits = channel.getLong();
            return new ServerId(new UUID(mostSigBits, leastSigBits));
        }

        public ServerId startState() {
            return null;
        }

        public long ordinal(ServerId serverId) {
            return serverId == null ? 0L : 1L;
        }
    }
}

