/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public class HeapTrackingLongEnumerationList<V>
extends DefaultCloseListenable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingLongEnumerationList.class);
    static final int DEFAULT_CHUNK_SIZE = 1024;
    private final int chunkSize;
    private final int chunkShiftAmount;
    private final MemoryTracker scopedMemoryTracker;
    private Chunk<V> firstChunk;
    private Chunk<V> lastChunk;
    private Chunk<V> secondLastChunk;
    private long firstKey;
    private long lastKey;
    private long lastKeyInFirstChunk;

    public static <V> HeapTrackingLongEnumerationList<V> create(MemoryTracker memoryTracker) {
        return HeapTrackingLongEnumerationList.create(memoryTracker, 1024);
    }

    public static <V> HeapTrackingLongEnumerationList<V> create(MemoryTracker memoryTracker, int chunkSize) {
        Preconditions.requirePowerOfTwo((long)chunkSize);
        MemoryTracker scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();
        scopedMemoryTracker.allocateHeap(SHALLOW_SIZE + HeapEstimator.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE);
        return new HeapTrackingLongEnumerationList<V>(scopedMemoryTracker, chunkSize);
    }

    private HeapTrackingLongEnumerationList(MemoryTracker scopedMemoryTracker, int chunkSize) {
        this.chunkSize = chunkSize;
        this.chunkShiftAmount = Integer.numberOfTrailingZeros(chunkSize);
        this.scopedMemoryTracker = scopedMemoryTracker;
        this.firstChunk = new Chunk(scopedMemoryTracker, chunkSize);
        this.lastChunk = this.firstChunk;
    }

    public V get(long key) {
        if (key < this.firstKey || key >= this.lastKey) {
            return null;
        }
        Chunk<V> chunk = this.findChunk(key);
        int indexInChunk = (int)key & this.chunkSize - 1;
        return (V)chunk.values[indexInChunk];
    }

    public V getFirst() {
        if (this.firstKey < this.lastKey) {
            return (V)this.firstChunk.values[(int)this.firstKey & this.chunkSize - 1];
        }
        return null;
    }

    public V put(long key, V value) {
        if (key < this.firstKey) {
            throw new IndexOutOfBoundsException(String.format("Cannot put key %s before first key %s", key, this.firstKey));
        }
        if (key >= this.lastKey) {
            while (this.lastKey < key) {
                this.add(null);
            }
            this.add(value);
            return null;
        }
        Chunk<V> chunk = this.findChunk(key);
        int indexInChunk = (int)key & this.chunkSize - 1;
        Object oldValue = chunk.values[indexInChunk];
        chunk.values[indexInChunk] = value;
        return (V)oldValue;
    }

    public void add(V value) {
        if (this.firstChunk == this.lastChunk) {
            this.addToSingleChunk(value);
        } else {
            this.addToTailChunk(value);
        }
    }

    private void addToSingleChunk(V value) {
        int chunkMask = this.chunkSize - 1;
        int firstIndexInChunk = (int)this.firstKey & chunkMask;
        int lastIndexInChunk = (int)this.lastKey & chunkMask;
        boolean addedNewChunk = false;
        if (lastIndexInChunk == firstIndexInChunk) {
            if (!this.isEmpty()) {
                Chunk newChunk = new Chunk(this.scopedMemoryTracker, this.chunkSize);
                this.secondLastChunk = this.lastChunk;
                this.lastChunk.next = newChunk;
                this.lastChunk = newChunk;
                addedNewChunk = true;
            } else if (value == null) {
                ++this.firstKey;
            }
        }
        this.lastChunk.values[lastIndexInChunk] = value;
        ++this.lastKey;
        if (!addedNewChunk) {
            this.lastKeyInFirstChunk = this.lastKey;
        }
    }

    private void addToTailChunk(V value) {
        int indexInChunk = (int)this.lastKey & this.chunkSize - 1;
        if (indexInChunk == 0) {
            Chunk newChunk = new Chunk(this.scopedMemoryTracker, this.chunkSize);
            this.secondLastChunk = this.lastChunk;
            this.lastChunk.next = newChunk;
            this.lastChunk = newChunk;
        }
        this.lastChunk.values[indexInChunk] = value;
        ++this.lastKey;
    }

    public V remove(long key) {
        if (key < this.firstKey || key >= this.lastKey) {
            return null;
        }
        if (this.firstChunk == this.lastChunk) {
            return this.removeInSingleChunk(key);
        }
        return this.removeInMultipleChunks(key);
    }

    private V removeInSingleChunk(long key) {
        Chunk<V> chunk = this.firstChunk;
        int chunkMask = this.chunkSize - 1;
        int firstIndexInChunk = (int)this.firstKey & chunkMask;
        int removeIndexInChunk = (int)key & chunkMask;
        Object removedValue = chunk.values[removeIndexInChunk];
        chunk.values[removeIndexInChunk] = null;
        while (this.firstKey < this.lastKey && this.firstChunk.values[firstIndexInChunk] == null) {
            ++this.firstKey;
            firstIndexInChunk = (int)this.firstKey & chunkMask;
        }
        return (V)removedValue;
    }

    private V removeInMultipleChunks(long key) {
        Chunk<V> chunk = this.findChunk(key);
        int chunkMask = this.chunkSize - 1;
        int indexInChunk = (int)key & chunkMask;
        Object removedValue = chunk.values[indexInChunk];
        chunk.values[indexInChunk] = null;
        if (key == this.firstKey) {
            this.updateFirstOfMultipleChunks(chunk, chunkMask);
        }
        return (V)removedValue;
    }

    private Chunk<V> findChunk(long key) {
        if (key < this.lastKeyInFirstChunk) {
            return this.firstChunk;
        }
        long keyChunkNumber = key >>> this.chunkShiftAmount;
        long lastChunkNumber = this.lastKey - 1L >>> this.chunkShiftAmount;
        if (keyChunkNumber == lastChunkNumber) {
            return this.lastChunk;
        }
        if (keyChunkNumber == lastChunkNumber - 1L) {
            return this.secondLastChunk;
        }
        Chunk chunk = this.firstChunk.next;
        long offset = key - this.lastKeyInFirstChunk;
        long alignment = this.lastKeyInFirstChunk & (long)(this.chunkSize - 1);
        long index = offset + alignment;
        long nChunkHops = index >>> this.chunkShiftAmount;
        int i = 0;
        while ((long)i < nChunkHops) {
            chunk = chunk.next;
            ++i;
        }
        return chunk;
    }

    private void updateFirstOfMultipleChunks(Chunk<V> chunk, int chunkMask) {
        int firstIndexInChunk = (int)this.firstKey & chunkMask;
        while (this.firstKey < this.lastKey && chunk.values[firstIndexInChunk] == null) {
            boolean moveToNextChunk;
            ++this.firstKey;
            if (chunk == this.firstChunk) {
                firstIndexInChunk = firstIndexInChunk + 1 & chunkMask;
                moveToNextChunk = this.firstKey >= this.lastKeyInFirstChunk;
            } else {
                boolean bl = moveToNextChunk = ++firstIndexInChunk >= this.chunkSize;
            }
            if (!moveToNextChunk || chunk == this.lastChunk) continue;
            firstIndexInChunk = (int)this.firstKey & chunkMask;
            chunk.close(this.scopedMemoryTracker);
            chunk = chunk.next;
        }
        if (chunk != this.firstChunk) {
            if (this.secondLastChunk == this.firstChunk) {
                this.secondLastChunk = null;
            }
            this.firstChunk = chunk;
            this.lastKeyInFirstChunk = chunk == this.lastChunk ? this.lastKey : (this.firstKey & (long)(~chunkMask)) + (long)this.chunkSize;
        }
    }

    private boolean isEmpty() {
        return this.firstKey == this.lastKey;
    }

    public void foreach(BiConsumer<Long, V> fun) {
        Object value;
        long key;
        Chunk<V> chunk = this.firstChunk;
        int chunkMask = this.chunkSize - 1;
        int index = (int)key & chunkMask;
        for (key = this.firstKey; key < this.lastKeyInFirstChunk; ++key) {
            value = chunk.values[index];
            if (value != null) {
                fun.accept(key, value);
            }
            index = index + 1 & chunkMask;
        }
        chunk = chunk.next;
        while (key < this.lastKey) {
            if (index >= this.chunkSize) {
                chunk = chunk.next;
                index = 0;
            }
            if ((value = chunk.values[index]) != null) {
                fun.accept(key, value);
            }
            ++index;
            ++key;
        }
    }

    public void removeUntil(long untilKey, BiConsumer<Long, V> fun) {
        long until = Math.min(untilKey, this.lastKey);
        while (this.firstKey < until) {
            long key = this.firstKey;
            V value = this.remove(key);
            fun.accept(key, value);
        }
    }

    public long lastKey() {
        return this.lastKey - 1L;
    }

    public MemoryTracker scopedMemoryTracker() {
        return this.scopedMemoryTracker;
    }

    public void closeInternal() {
        this.firstChunk = null;
        this.lastChunk = null;
        this.secondLastChunk = null;
        this.scopedMemoryTracker.close();
    }

    public boolean isClosed() {
        return this.firstChunk == null;
    }

    public Iterator<V> valuesIterator() {
        if (this.isEmpty()) {
            return Collections.emptyIterator();
        }
        if (this.firstChunk == this.lastChunk) {
            return new SingleChunkValuesIterator();
        }
        return new ValuesIterator();
    }

    private static class Chunk<V> {
        private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Chunk.class);
        private final Object[] values;
        private Chunk<V> next;

        Chunk(MemoryTracker memoryTracker, int chunkSize) {
            memoryTracker.allocateHeap(SHALLOW_SIZE + HeapEstimator.shallowSizeOfObjectArray((int)chunkSize));
            this.values = new Object[chunkSize];
        }

        void close(MemoryTracker memoryTracker) {
            memoryTracker.releaseHeap(SHALLOW_SIZE + HeapEstimator.shallowSizeOfObjectArray((int)this.values.length));
        }
    }

    private class ValuesIterator
    implements Iterator<V> {
        private Chunk<V> chunk;
        private int index;
        private long key;

        private ValuesIterator() {
            this.chunk = HeapTrackingLongEnumerationList.this.firstChunk;
            this.key = HeapTrackingLongEnumerationList.this.firstKey;
            this.index = (int)HeapTrackingLongEnumerationList.this.firstKey & HeapTrackingLongEnumerationList.this.chunkSize - 1;
        }

        @Override
        public boolean hasNext() {
            return this.chunk != null && this.chunk.values[this.index] != null;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object value = this.chunk.values[this.index];
            if (this.chunk == HeapTrackingLongEnumerationList.this.firstChunk) {
                this.findNextInFirstChunk();
            } else {
                this.findNextInTailChunks();
            }
            return value;
        }

        private void findNextInFirstChunk() {
            boolean hasRemainingElements;
            do {
                ++this.key;
                this.index = this.index + 1 & HeapTrackingLongEnumerationList.this.chunkSize - 1;
                boolean bl = hasRemainingElements = this.key < HeapTrackingLongEnumerationList.this.lastKeyInFirstChunk;
            } while (hasRemainingElements && this.chunk.values[this.index] == null);
            if (hasRemainingElements) {
                return;
            }
            this.chunk = this.chunk.next;
            if (this.chunk != null && this.chunk.values[this.index] == null && this.key < HeapTrackingLongEnumerationList.this.lastKey) {
                this.findNextInTailChunks();
            }
        }

        private void findNextInTailChunks() {
            do {
                ++this.key;
                ++this.index;
                if (this.index < HeapTrackingLongEnumerationList.this.chunkSize) continue;
                this.index = 0;
                this.chunk = this.chunk.next;
            } while (this.chunk != null && this.chunk.values[this.index] == null && this.key < HeapTrackingLongEnumerationList.this.lastKey);
        }
    }

    private class SingleChunkValuesIterator
    implements Iterator<V> {
        private Chunk<V> chunk;
        private long key;

        private SingleChunkValuesIterator() {
            this.chunk = HeapTrackingLongEnumerationList.this.firstChunk;
            this.key = HeapTrackingLongEnumerationList.this.firstKey;
        }

        @Override
        public boolean hasNext() {
            int index = (int)this.key & HeapTrackingLongEnumerationList.this.chunkSize - 1;
            return this.key < HeapTrackingLongEnumerationList.this.lastKeyInFirstChunk && this.chunk.values[index] != null;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int chunkMask = HeapTrackingLongEnumerationList.this.chunkSize - 1;
            int index = (int)this.key & chunkMask;
            Object value = this.chunk.values[index];
            do {
                ++this.key;
                index = index + 1 & chunkMask;
            } while (this.key < HeapTrackingLongEnumerationList.this.lastKeyInFirstChunk && this.chunk.values[index] == null);
            return value;
        }
    }
}

