/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.pruning.EntryCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.EntryTimespanThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.FileCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.FileSizeThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.kernel.impl.transaction.log.pruning.ThresholdBasedPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.ThresholdConfigParser;
import org.neo4j.logging.LogProvider;
import org.neo4j.util.VisibleForTesting;

public class LogPruneStrategyFactory {
    static final LogPruneStrategy NO_PRUNING = new LogPruneStrategy(){

        @Override
        public LongRange findLogVersionsToDelete(long upToLogVersion) {
            return LongRange.EMPTY_RANGE;
        }

        public String toString() {
            return "keep_all";
        }
    };

    LogPruneStrategy strategyFromConfigValue(FileSystemAbstraction fileSystem, LogFiles logFiles, LogProvider logProvider, Clock clock, String configValue) {
        ThresholdConfigParser.ThresholdConfigValue value = ThresholdConfigParser.parse(configValue);
        if (value == ThresholdConfigParser.ThresholdConfigValue.NO_PRUNING) {
            return NO_PRUNING;
        }
        Threshold thresholdToUse = LogPruneStrategyFactory.getThresholdByType(fileSystem, logProvider, clock, value, configValue);
        return new ThresholdBasedPruneStrategy(logFiles.getLogFile(), thresholdToUse);
    }

    @VisibleForTesting
    static Threshold getThresholdByType(FileSystemAbstraction fileSystem, LogProvider logProvider, Clock clock, ThresholdConfigParser.ThresholdConfigValue value, String originalConfigValue) {
        long thresholdValue = value.value;
        switch (value.type) {
            case "files": {
                return new FileCountThreshold(thresholdValue);
            }
            case "size": {
                return new FileSizeThreshold(fileSystem, thresholdValue);
            }
            case "txs": 
            case "entries": {
                return new EntryCountThreshold(logProvider, thresholdValue);
            }
            case "hours": {
                return new EntryTimespanThreshold(logProvider, clock, TimeUnit.HOURS, thresholdValue);
            }
            case "days": {
                return new EntryTimespanThreshold(logProvider, clock, TimeUnit.DAYS, thresholdValue);
            }
        }
        throw new IllegalArgumentException("Invalid log pruning configuration value '" + originalConfigValue + "'. Invalid type '" + value.type + "', valid are files, size, txs, entries, hours, days.");
    }
}

