/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntriesReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.kernel.impl.index.schema.NativeAllEntriesReader;
import org.neo4j.kernel.impl.index.schema.NativeIndex;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;

public abstract class NativeIndexAccessor<KEY extends NativeIndexKey<KEY>>
extends NativeIndex<KEY>
implements IndexAccessor {
    private final NativeIndexUpdater<KEY> singleUpdater;
    final NativeIndexHeaderWriter headerWriter;

    NativeIndexAccessor(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexLayout<KEY> layout, IndexDescriptor descriptor) {
        super(databaseIndexContext, layout, indexFiles, descriptor);
        this.singleUpdater = new NativeIndexUpdater<NativeIndexKey>((NativeIndexKey)((Object)layout.newKey()), this.indexUpdateIgnoreStrategy());
        this.headerWriter = new NativeIndexHeaderWriter(1);
    }

    public void drop() {
        this.tree.setDeleteOnClose(true);
        this.closeTree();
        this.indexFiles.clear();
    }

    public NativeIndexUpdater<KEY> newUpdater(IndexUpdateMode mode, CursorContext cursorContext) {
        this.assertOpen();
        try {
            return this.singleUpdater.initialize(this.tree.writer(cursorContext));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected IndexUpdateIgnoreStrategy indexUpdateIgnoreStrategy() {
        return IndexUpdateIgnoreStrategy.NO_IGNORE;
    }

    public void force(CursorContext cursorContext) {
        this.tree.checkpoint(cursorContext);
    }

    public void refresh() {
    }

    public void close() {
        this.closeTree();
    }

    public abstract ValueIndexReader newValueReader();

    public BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
        return new NativeAllEntriesReader(this.tree, this.layout, fromIdInclusive, toIdExclusive, cursorContext);
    }

    public ResourceIterator<Path> snapshotFiles() {
        return Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)this.indexFiles.getStoreFile()));
    }

    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) {
    }

    public long estimateNumberOfEntries(CursorContext cursorContext) {
        try {
            return this.tree.estimateNumberOfEntriesInTree(cursorContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (TreeInconsistencyException e) {
            return -1L;
        }
    }

    public IndexEntriesReader[] newAllEntriesValueReader(int partitions, CursorContext cursorContext) {
        NativeIndexKey lowest = (NativeIndexKey)((Object)this.layout.newKey());
        lowest.initialize(Long.MIN_VALUE);
        lowest.initValuesAsLowest();
        NativeIndexKey highest = (NativeIndexKey)((Object)this.layout.newKey());
        highest.initialize(Long.MAX_VALUE);
        highest.initValuesAsHighest();
        try {
            Collection seekersWithContext = this.tree.partitionedSeek((Object)lowest, (Object)highest, partitions, cursorContext);
            ArrayList<1> readers = new ArrayList<1>();
            for (Seeker.WithContext seekerWithContext : seekersWithContext) {
                final Seeker seeker = seekerWithContext.with(cursorContext);
                readers.add(new IndexEntriesReader(){

                    public long next() {
                        return ((NativeIndexKey)((Object)seeker.key())).getEntityId();
                    }

                    public boolean hasNext() {
                        try {
                            return seeker.next();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }

                    public Value[] values() {
                        return ((NativeIndexKey)((Object)seeker.key())).asValues();
                    }

                    public void close() {
                        try {
                            seeker.close();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                });
            }
            return (IndexEntriesReader[])readers.toArray(IndexEntriesReader[]::new);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

