/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Mark;
import org.neo4j.csv.reader.Readables;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.unsafe.impl.batchimport.input.DuplicateHeaderException;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.HeaderException;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.Data;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Decorator;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TemporalValue;

public class DataFactories {
    private static Supplier<ZoneId> defaultTimeZone = () -> ZoneOffset.UTC;
    private static Pattern typeSpecAndOptionalParameter = Pattern.compile("(?<newTypeSpec>.+?)(?<optionalParameter>\\{.*\\})?$");

    private DataFactories() {
    }

    public static DataFactory data(final Decorator decorator, final Charset charset, final File ... files) {
        if (files.length == 0) {
            throw new IllegalArgumentException("No files specified");
        }
        return config -> new Data(){

            @Override
            public RawIterator<CharReadable, IOException> stream() {
                return Readables.individualFiles((Charset)charset, (File[])files);
            }

            @Override
            public Decorator decorator() {
                return decorator;
            }
        };
    }

    public static DataFactory data(final Decorator decorator, final Supplier<CharReadable> readable) {
        return config -> new Data(){

            @Override
            public RawIterator<CharReadable, IOException> stream() {
                return Readables.iterator(reader -> reader, (Object[])new CharReadable[]{(CharReadable)readable.get()});
            }

            @Override
            public Decorator decorator() {
                return decorator;
            }
        };
    }

    public static Header.Factory defaultFormatNodeFileHeader(Supplier<ZoneId> defaultTimeZone) {
        return new DefaultNodeFileHeaderParser(defaultTimeZone);
    }

    public static Header.Factory defaultFormatNodeFileHeader() {
        return DataFactories.defaultFormatNodeFileHeader(defaultTimeZone);
    }

    public static Header.Factory defaultFormatRelationshipFileHeader(Supplier<ZoneId> defaultTimeZone) {
        return new DefaultRelationshipFileHeaderParser(defaultTimeZone);
    }

    public static Header.Factory defaultFormatRelationshipFileHeader() {
        return DataFactories.defaultFormatRelationshipFileHeader(defaultTimeZone);
    }

    private static Extractor<?> parsePropertyType(String typeSpec, Extractors extractors) {
        try {
            return extractors.valueOf(typeSpec);
        }
        catch (IllegalArgumentException e) {
            throw new HeaderException("Unable to parse header", e);
        }
    }

    @SafeVarargs
    public static Iterable<DataFactory> datas(DataFactory ... factories) {
        return Iterables.iterable((Object[])factories);
    }

    public static Pair<String, String> splitTypeSpecAndOptionalParameter(String typeSpec) {
        String optionalParameter = null;
        String newTypeSpec = typeSpec;
        Matcher matcher = typeSpecAndOptionalParameter.matcher(typeSpec);
        if (matcher.find()) {
            try {
                newTypeSpec = matcher.group("newTypeSpec");
                optionalParameter = matcher.group("optionalParameter");
            }
            catch (IllegalArgumentException e) {
                String errorMessage = String.format("Failed to parse header: '%s'", typeSpec);
                throw new IllegalArgumentException(errorMessage, e);
            }
        }
        return Pair.of((Object)newTypeSpec, optionalParameter);
    }

    private static class DefaultRelationshipFileHeaderParser
    extends AbstractDefaultFileHeaderParser {
        protected DefaultRelationshipFileHeaderParser(Supplier<ZoneId> defaultTimeZone) {
            super(defaultTimeZone, false, Type.START_ID, Type.END_ID);
        }

        @Override
        protected Header.Entry entry(int index, String name, String typeSpec, Group group, Extractors extractors, Extractor<?> idExtractor) {
            Type type = null;
            Extractor extractor = null;
            PointValue.PointBuilder optionalParameter = null;
            if (typeSpec == null) {
                type = Type.PROPERTY;
                extractor = extractors.string();
            } else {
                Pair<String, String> split = DataFactories.splitTypeSpecAndOptionalParameter(typeSpec);
                typeSpec = (String)split.first();
                String optionalParameterString = (String)split.other();
                if (optionalParameterString != null) {
                    if ("Point".equals(typeSpec)) {
                        optionalParameter = PointValue.parseHeaderInformation((CharSequence)optionalParameterString);
                    } else if ("Time".equals(typeSpec) || "DateTime".equals(typeSpec)) {
                        optionalParameter = TemporalValue.parseHeaderInformation((String)optionalParameterString);
                    }
                }
                if (typeSpec.equalsIgnoreCase(Type.START_ID.name())) {
                    type = Type.START_ID;
                    extractor = idExtractor;
                } else if (typeSpec.equalsIgnoreCase(Type.END_ID.name())) {
                    type = Type.END_ID;
                    extractor = idExtractor;
                } else if (typeSpec.equalsIgnoreCase(Type.TYPE.name())) {
                    type = Type.TYPE;
                    extractor = extractors.string();
                } else {
                    if (this.isRecognizedType(typeSpec)) {
                        throw new HeaderException("Unexpected relationship header type '" + typeSpec + "'");
                    }
                    type = Type.PROPERTY;
                    extractor = DataFactories.parsePropertyType(typeSpec, extractors);
                }
            }
            return new Header.Entry(name, type, group, (Extractor<?>)extractor, (CSVHeaderInformation)optionalParameter);
        }
    }

    private static class DefaultNodeFileHeaderParser
    extends AbstractDefaultFileHeaderParser {
        protected DefaultNodeFileHeaderParser(Supplier<ZoneId> defaultTimeZone) {
            super(defaultTimeZone, true, new Type[0]);
        }

        @Override
        protected Header.Entry entry(int index, String name, String typeSpec, Group group, Extractors extractors, Extractor<?> idExtractor) {
            Type type = null;
            Extractor extractor = null;
            PointValue.PointBuilder optionalParameter = null;
            if (typeSpec == null) {
                type = Type.PROPERTY;
                extractor = extractors.string();
            } else {
                Pair<String, String> split = DataFactories.splitTypeSpecAndOptionalParameter(typeSpec);
                typeSpec = (String)split.first();
                String optionalParameterString = (String)split.other();
                if (optionalParameterString != null) {
                    if ("Point".equals(typeSpec)) {
                        optionalParameter = PointValue.parseHeaderInformation((CharSequence)optionalParameterString);
                    } else if ("Time".equals(typeSpec) || "DateTime".equals(typeSpec)) {
                        optionalParameter = TemporalValue.parseHeaderInformation((String)optionalParameterString);
                    }
                }
                if (typeSpec.equalsIgnoreCase(Type.ID.name())) {
                    type = Type.ID;
                    extractor = idExtractor;
                } else if (typeSpec.equalsIgnoreCase(Type.LABEL.name())) {
                    type = Type.LABEL;
                    extractor = extractors.stringArray();
                } else {
                    if (this.isRecognizedType(typeSpec)) {
                        throw new HeaderException("Unexpected node header type '" + typeSpec + "'");
                    }
                    type = Type.PROPERTY;
                    extractor = DataFactories.parsePropertyType(typeSpec, extractors);
                }
            }
            return new Header.Entry(name, type, group, (Extractor<?>)extractor, (CSVHeaderInformation)optionalParameter);
        }
    }

    private static class HeaderEntrySpec {
        private final String name;
        private final String type;
        private final String groupName;

        HeaderEntrySpec(String rawHeaderField) {
            String rawHeaderUntilOptions;
            int typeIndex;
            String name = rawHeaderField;
            String type = null;
            String groupName = null;
            if (rawHeaderField != null && (typeIndex = (rawHeaderUntilOptions = rawHeaderField.split("\\{")[0]).lastIndexOf(58)) != -1) {
                name = typeIndex > 0 ? rawHeaderField.substring(0, typeIndex) : null;
                type = rawHeaderField.substring(typeIndex + 1);
                int groupNameStartIndex = type.indexOf(40);
                if (groupNameStartIndex != -1) {
                    if (!type.endsWith(")")) {
                        throw new IllegalArgumentException("Group specification in '" + rawHeaderField + "' is invalid, format expected to be 'name:TYPE(group)' where TYPE and (group) are optional");
                    }
                    groupName = type.substring(groupNameStartIndex + 1, type.length() - 1);
                    type = type.substring(0, groupNameStartIndex);
                }
            }
            this.name = name;
            this.type = type;
            this.groupName = groupName;
        }
    }

    private static abstract class AbstractDefaultFileHeaderParser
    implements Header.Factory {
        private final boolean createGroups;
        private final Type[] mandatoryTypes;
        private final Supplier<ZoneId> defaultTimeZone;

        protected AbstractDefaultFileHeaderParser(Supplier<ZoneId> defaultTimeZone, boolean createGroups, Type ... mandatoryTypes) {
            this.defaultTimeZone = defaultTimeZone;
            this.createGroups = createGroups;
            this.mandatoryTypes = mandatoryTypes;
        }

        @Override
        public Header create(CharSeeker dataSeeker, Configuration config, IdType idType, Groups groups) {
            try {
                Mark mark = new Mark();
                Extractors extractors = new Extractors(config.arrayDelimiter(), config.emptyQuotedStringsAsNull(), config.trimStrings(), this.defaultTimeZone);
                Extractor<?> idExtractor = idType.extractor(extractors);
                char delimiter = config.delimiter();
                ArrayList<Header.Entry> columns = new ArrayList<Header.Entry>();
                int i = 0;
                while (!mark.isEndOfLine() && dataSeeker.seek(mark, (int)delimiter)) {
                    String entryString = dataSeeker.tryExtract(mark, extractors.string()) ? (String)extractors.string().value() : null;
                    HeaderEntrySpec spec = new HeaderEntrySpec(entryString);
                    if (spec.name == null && spec.type == null || spec.type != null && spec.type.equals(Type.IGNORE.name())) {
                        columns.add(new Header.Entry(null, Type.IGNORE, Group.GLOBAL, null, null));
                    } else {
                        Group group = this.createGroups ? groups.getOrCreate(spec.groupName) : groups.get(spec.groupName);
                        columns.add(this.entry(i, spec.name, spec.type, group, extractors, idExtractor));
                    }
                    ++i;
                }
                Header.Entry[] entries = columns.toArray(new Header.Entry[columns.size()]);
                this.validateHeader(entries);
                return new Header(entries);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void validateHeader(Header.Entry[] entries) {
            HashMap<String, Header.Entry> properties = new HashMap<String, Header.Entry>();
            EnumMap<Type, Header.Entry> singletonEntries = new EnumMap<Type, Header.Entry>(Type.class);
            block4: for (Header.Entry entry : entries) {
                switch (entry.type()) {
                    case PROPERTY: {
                        Header.Entry existingPropertyEntry = (Header.Entry)properties.get(entry.name());
                        if (existingPropertyEntry != null) {
                            throw new DuplicateHeaderException(existingPropertyEntry, entry);
                        }
                        properties.put(entry.name(), entry);
                        continue block4;
                    }
                    case ID: 
                    case START_ID: 
                    case END_ID: 
                    case TYPE: {
                        Header.Entry existingSingletonEntry = (Header.Entry)singletonEntries.get((Object)entry.type());
                        if (existingSingletonEntry != null) {
                            throw new DuplicateHeaderException(existingSingletonEntry, entry);
                        }
                        singletonEntries.put(entry.type(), entry);
                        continue block4;
                    }
                }
            }
            for (Type type : this.mandatoryTypes) {
                if (singletonEntries.containsKey((Object)type)) continue;
                throw new HeaderException(String.format("Missing header of type %s, among entries %s", new Object[]{type, Arrays.toString(entries)}));
            }
        }

        protected boolean isRecognizedType(String typeSpec) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(typeSpec)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isDefined() {
            return false;
        }

        protected abstract Header.Entry entry(int var1, String var2, String var3, Group var4, Extractors var5, Extractor<?> var6);
    }
}

