/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

enum RelationshipConnection {
    START_PREV{

        @Override
        long get(RelationshipRecord rel) {
            return rel.isFirstInFirstChain() ? (long)Record.NO_NEXT_RELATIONSHIP.intValue() : rel.getFirstPrevRel();
        }

        @Override
        void set(RelationshipRecord rel, long id, boolean isFirst) {
            rel.setFirstPrevRel(id);
            rel.setFirstInFirstChain(isFirst);
        }

        @Override
        RelationshipConnection otherSide() {
            return START_NEXT;
        }

        @Override
        long compareNode(RelationshipRecord rel) {
            return rel.getFirstNode();
        }

        @Override
        RelationshipConnection start() {
            return this;
        }

        @Override
        RelationshipConnection end() {
            return END_PREV;
        }

        @Override
        boolean isFirstInChain(RelationshipRecord rel) {
            return rel.isFirstInFirstChain();
        }
    }
    ,
    START_NEXT{

        @Override
        long get(RelationshipRecord rel) {
            return rel.getFirstNextRel();
        }

        @Override
        void set(RelationshipRecord rel, long id, boolean isFirst) {
            rel.setFirstNextRel(id);
        }

        @Override
        RelationshipConnection otherSide() {
            return START_PREV;
        }

        @Override
        long compareNode(RelationshipRecord rel) {
            return rel.getFirstNode();
        }

        @Override
        RelationshipConnection start() {
            return this;
        }

        @Override
        RelationshipConnection end() {
            return END_NEXT;
        }

        @Override
        boolean isFirstInChain(RelationshipRecord rel) {
            return rel.isFirstInFirstChain();
        }
    }
    ,
    END_PREV{

        @Override
        long get(RelationshipRecord rel) {
            return rel.isFirstInSecondChain() ? (long)Record.NO_NEXT_RELATIONSHIP.intValue() : rel.getSecondPrevRel();
        }

        @Override
        void set(RelationshipRecord rel, long id, boolean isFirst) {
            rel.setSecondPrevRel(id);
            rel.setFirstInSecondChain(isFirst);
        }

        @Override
        RelationshipConnection otherSide() {
            return END_NEXT;
        }

        @Override
        long compareNode(RelationshipRecord rel) {
            return rel.getSecondNode();
        }

        @Override
        RelationshipConnection start() {
            return START_PREV;
        }

        @Override
        RelationshipConnection end() {
            return this;
        }

        @Override
        boolean isFirstInChain(RelationshipRecord rel) {
            return rel.isFirstInSecondChain();
        }
    }
    ,
    END_NEXT{

        @Override
        long get(RelationshipRecord rel) {
            return rel.getSecondNextRel();
        }

        @Override
        void set(RelationshipRecord rel, long id, boolean isFirst) {
            rel.setSecondNextRel(id);
        }

        @Override
        RelationshipConnection otherSide() {
            return END_PREV;
        }

        @Override
        long compareNode(RelationshipRecord rel) {
            return rel.getSecondNode();
        }

        @Override
        RelationshipConnection start() {
            return START_NEXT;
        }

        @Override
        RelationshipConnection end() {
            return this;
        }

        @Override
        boolean isFirstInChain(RelationshipRecord rel) {
            return rel.isFirstInSecondChain();
        }
    };


    abstract long get(RelationshipRecord var1);

    abstract boolean isFirstInChain(RelationshipRecord var1);

    abstract void set(RelationshipRecord var1, long var2, boolean var4);

    abstract long compareNode(RelationshipRecord var1);

    abstract RelationshipConnection otherSide();

    abstract RelationshipConnection start();

    abstract RelationshipConnection end();
}

